% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm.R
\name{gbm}
\alias{gbm}
\title{Geometric Brownian motion spatPomp simulator}
\usage{
gbm(U = 5, N = 100, delta_t = 0.1, IVP_values = 1, delta_obs = 1)
}
\arguments{
\item{U}{A length-one numeric signifying dimension of the process.}

\item{N}{A length-one numeric signifying the number of time steps to evolve the process.}

\item{delta_t}{process simulations are performed every \code{delta_t} time units}

\item{IVP_values}{initial value parameters for the latent states}

\item{delta_obs}{observations occur every \code{delta_obs} time units}
}
\value{
An object of class \sQuote{spatPomp} representing a simulation from a \code{U}-dimensional
geometric Brownian motion
}
\description{
Generate a spatPomp object representing a \code{U}-dimensional
geometric Brownian motion with spatial correlation decaying geometrically with
distance around a circle. The model is defined in continuous time, but
an Euler approximation is used for this numerical implementation.
}
\examples{
# Complete examples are provided in the package tests
\dontrun{
g <- gbm(U=4, N=20)
# See all the model specifications of the object
spy(g)
}

}
\references{
\asfaw2021thesis
}
\seealso{
Other spatPomp model generators: 
\code{\link{bm}()},
\code{\link{bm2}()},
\code{\link{he10}()},
\code{\link{lorenz}()},
\code{\link{measles}()}
}
\author{
Kidus Asfaw
}
\concept{spatPomp model generators}
