% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_formats.R
\name{expand_params}
\alias{expand_params}
\alias{contract_params,}
\alias{mean_by_unit,}
\alias{expand_params,}
\alias{param_formats}
\alias{contract_params}
\alias{mean_by_unit}
\title{Book-keeping functions for working with expanded parameters}
\usage{
expand_params(params, expandedParNames, U)

contract_params(params, expandedParNames, U, average = FALSE)

mean_by_unit(params, expandedParNames, U)
}
\arguments{
\item{params}{Input parameter vector}

\item{expandedParNames}{character vector of parameters that are, or
should be, expanded. These names should have no numerical suffix 1:U.}

\item{U}{Number of units}

\item{average}{Logical value for whether contract_params should
average unequal values}
}
\description{
Iterated block particle filters require shared parameters to be
expanded into having a value at each unit. expand_params, contract_params
and mean_by_unit provide tools for moving between representations.
For a unit-specific expansion of a shared parameter, all the values for
different units should be the same, and mean_by_unit ensures this
by taking an average.
}
\details{
These functions assume that expanded parameters have names ending
in "1" through "U", where U is the number of units. Contracted parameters, 
meaning any parameter that is not expanded, should have a name ending
in "1". This numerical suffix convention is useful for writing model-building 
code that allows parameters to be either expanded or contracted.
}
\seealso{
Other utilities: 
\code{\link{arma_benchmark}()}
}
\concept{utilities}
