% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/breeding.density.R
\name{breeding.density}
\alias{breeding.density}
\title{Breeding density areas}
\usage{
breeding.density(x, pop, p = 0.75, bw = 1000, b = 6400, self = TRUE)
}
\arguments{
\item{x}{sp SpatialPointsDataFrame object}

\item{pop}{Population count/density column in x@data}

\item{p}{Target percent of population}

\item{bw}{Bandwidth distance}

\item{b}{Buffer distance (eg., p < 0.75 b=6400m, p >= 0.75 b=8500m)}

\item{self}{Should source observations be included in neighbour count (TRUE/FALSE)}
}
\value{
A list object with:

pop.pts     sp point object with points identified within the specified p

pop.area    sp polygon object of buffered points specified by parameter b

bandwidth   Specified distance bandwidth used in identifying neighbour counts

buffer      Specified buffer distance used in buffering points for pop.area

p           Specified population percent
}
\description{
Calculates breeding density areas base on population counts/density and spatial point density.
}
\note{
The breeding density areas model identifies the Nth-percent population exhibiting the highest spatial density and counts/frequency. It then buffers these points by a specified distance to produce breeding area polygons.

depends: sp, rgeos
}
\examples{
require(sp)
n=1500
bb <- rbind(c(-1281299,-761876.5),c(1915337,2566433.5))
  bb.mat <- cbind(c(bb[1,1], bb[1,2], bb[1,2], bb[1,1]),
                  c(bb[2,1], bb[2,1], bb[2,2], bb[2,2]))
    bbp <- Polygon(bb.mat)
     s <- spsample(bbp, n, type='random')
        pop <- SpatialPointsDataFrame(s, data.frame(ID=1:length(s),
                                 counts=runif(length(s), 1,250)))

    bd75 <- breeding.density(pop, pop='counts', p=0.75, b=6400, bw=4000)
     plot(bd75$pop.area, main='75\% breeding density areas')
       plot(pop, pch=20, col='black', add=TRUE)
         plot(bd75$pop.pts, pch=20, col='red', add=TRUE)
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
\references{
Doherty, K.E., J.D. Tack, J.S. Evans, D.E. Naugle (2010) Mapping breeding densities of greater sage-grouse: A tool for range-wide conservation planning. Bureau of Land Management. Report Number L10PG00911
}

