% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate.polygon.R
\name{rotate.polygon}
\alias{rotate.polygon}
\title{Rotate polygon}
\usage{
rotate.polygon(
  p,
  angle = 45,
  sp = FALSE,
  anchor = c("center", "lower.left", "upper.right")
)
}
\arguments{
\item{p}{A polygon object of sf or sp class}

\item{angle}{Rotation angle in degrees}

\item{sp}{(FALSE | TRUE) Output sp class object}

\item{anchor}{Location to rotate polygon on options are "center", 
"lower.left" and "upper.right"}
}
\value{
an sp or sf polygon object with rotated polygon
}
\description{
rotates polygon by specified angle
}
\note{
The anchor is the location that the rotation is anchored to. The center
is the centroid where the lower.left and upper.right are based on the 
min or max of the coordinates respectively.
}
\examples{
library(sp)
library(rgeos)

data(meuse)
  coordinates(meuse) <- ~x+y

e <- gConvexHull(meuse)
  e30 <- rotate.polygon(e, angle=30, sp=TRUE)

plot(e, main="rotated 30 degrees")
  plot(e30, add=TRUE)

}
