% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{interaction_variable}
\alias{interaction_variable}
\title{Bivariate Interaction Variable}
\usage{
interaction_variable(
  mif,
  mnames,
  r_range = NULL,
  num_permutations = 100,
  keep_permutation_distribution = FALSE,
  workers = 1,
  overwrite = FALSE,
  xloc = NULL,
  yloc = NULL
)
}
\arguments{
\item{mif}{object of class `mif`}

\item{mnames}{a character vector or table with 2 columns indicating the from-to markers to assess}

\item{r_range}{numeric vector of radii for which to calculate the interaction variable at}

\item{num_permutations}{integer for how many permutations to use to derive the interaction estimate under CSR}

\item{keep_permutation_distribution}{boolean for whether or not to keep all permutation results or average them}

\item{workers}{integer for the number of CPU cores to use for permutations, markers, and spatial samples}

\item{overwrite}{boolean for whether to overwrite existing interaction variable results}

\item{xloc}{column name in spatial files containing the x location - if left NULL will average columns XMin and XMax}

\item{yloc}{column name in spatial files containing the y location - if left NULL will average columns YMin and YMax}
}
\value{
object of class mif with the interaction variable derive slot filled
}
\description{
Single-cell spatial-protein metric introduce by Steinhart et al in https://doi.org/10.1158/1541-7786.mcr-21-0411
}
