% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ripleys_k.R
\name{ripleys_k}
\alias{ripleys_k}
\title{Calculate Ripley's K}
\usage{
ripleys_k(
  mif,
  mnames,
  r_range = seq(0, 100, 1),
  num_permutations = 50,
  edge_correction = "translation",
  method = "K",
  permute = FALSE,
  keep_permutation_distribution = FALSE,
  workers = 1,
  overwrite = FALSE,
  xloc = NULL,
  yloc = NULL,
  big = 10000
)
}
\arguments{
\item{mif}{object of class `mif` created with `create_mif`}

\item{mnames}{cell phenotype markers to calculate Ripley's K for}

\item{r_range}{radius range (including 0)}

\item{num_permutations}{number of permutations to use to estimate CSR. If `keep_perm_dis` is set to FALSE, this will be ignored}

\item{edge_correction}{edge correction method to pass to `Kest`. can take one of "translation", "isotropic", "none", or 'border'}

\item{method}{not used currently}

\item{permute}{whether to use CSR estimate or use permutations to determine CSR}

\item{keep_permutation_distribution}{whether to find mean of permutation distribution or each
permutation calculation}

\item{workers}{number of cores to use for calculations}

\item{overwrite}{whether to overwrite the `univariate_Count` slot within `mif$derived`}

\item{xloc}{the location of the center of cells. If left `NULL`, `XMin`, `XMax`, `YMin`, and `YMax` must be present.}

\item{yloc}{the location of the center of cells. If left `NULL`, `XMin`, `XMax`, `YMin`, and `YMax` must be present.}

\item{big}{the number of cells at which to flip from an edge correction method other than 'none' to 'none' due to size}
}
\value{
object of class `mif`
}
\description{
ripleys_k() calculates the emperical Ripley's K measurement for the cell types specified by mnames in the mIF object. This
is very useful when exploring the spatial clustering of single cell types on TMA cores or ROI spots following proccessing
with a program such as HALO for cell phenotyping.

In the `ripleys_k` function, there is the ability to perform permutations in order to assess whether the clustering
of a cell type is significant, or the ability to derive the exact CSR and forgo permutations for much faster sample
processing. Permutations can be helpful if the significance of clustering wasnts to be identified - run 1000 permutations 
and if observed is outside 95-percentile then significant clustering. We, however, recommend using the exact CSR estimate
due to speed.

Some things to be aware of when computing the exact Ripley's K estimate, if your spatial file is greater than 
the `big` size, the edge correction will be converted to 'none' in order to save on resources and compute time. 
Due to the introduction of Whole Slide Imaging (WSI), this can easily be well over 1,000,000 cells, and calculating 
edge correction for these spatial files will not succeed when attempting to force an edge correction on it.
}
\examples{
x <- spatialTIME::create_mif(clinical_data =spatialTIME::example_clinical \%>\% 
  dplyr::mutate(deidentified_id = as.character(deidentified_id)),
  sample_data = spatialTIME::example_summary \%>\% 
  dplyr::mutate(deidentified_id = as.character(deidentified_id)),
  spatial_list = spatialTIME::example_spatial,
  patient_id = "deidentified_id", 
  sample_id = "deidentified_sample")
mnames = x$spatial[[1]] \%>\%
  colnames() \%>\%
  grep("Pos|CD", ., value =TRUE) \%>\%
  grep("Cyto|Nucle", ., value =TRUE, invert =TRUE)
x2 = ripleys_k(mif = x, 
  mnames = mnames[1], 
  r_range = seq(0, 100, 1), 
  num_permutations = 100,
  edge_correction = "translation", 
  method = "K", 
  permute = FALSE,
  keep_permutation_distribution =FALSE, 
  workers = 1, 
  overwrite =TRUE)
}
