\name{minglingF}
\alias{minglingF}
\alias{mingling.index}

\title{Spatial Mingling Index}
\description{
Compute the Mingling index for a given multitype point pattern.
}


\details{
Extension of Mingling index introduced by Lewandowski\&Pommerening 1997. Measures the proportion of alien points in
the neighbourhood of a specific type typical point of the pattern.

If no specific type is given, the function takes mean over all types. A typewise value is more useful, so they are also included.

The function \code{minglingF} is the main calculation function. Uses function \code{\link{segregationFun}}. 

The function \code{mingling.index} is a shortcut to get a single value for the pattern. Uses 4-nn graph by default, which is the original 
Mingling index used by Lewandowski\&Pommerening 1997 and Graz 2004. 
}

\usage{
minglingF(X, r=NULL, target=NULL, ratio=FALSE, ...)
mingling.index(X, r=4, ntype="knn", ...)
}

\arguments{
\item{X}{Multitype point pattern of class \code{ppp} (see package 'spatstat')}
\item{r}{Vector of sizes for neighbourhoods, e.g. \code{geometric} graph with different ranges.}
\item{target}{Default NULL. Calculate only for target type. If NULL computes for each type + mean over all types.}
\item{ratio}{Default FALSE. If TRUE, scale the typewise values \code{$M_t$} using formula \code{$(1-M_tau)/lambda_tau$} which equals 1 for Poisson CSR.}
\item{ntype}{The original mingling index uses \code{knn} neighbourhood type.}
\item{...}{Further parameters for the function \code{segregationFun}.}
}
\value{
 Returns an \code{fv}-object, see \code{spatstat} for more information.
}

\author{
Tuomas Rajala
University of Jyvaskyla, Finland
tuomas.a.rajala@jyu.fi
}
\references{
Graz: The behaviour of the species mingling index \code{$m_{sp}$} in relation to species dominance and dispersion. Eur. J. forest research. 123:87-92, 2004.

Lewandowski, Pommerening: Zur Beschreibung der Waldstruktur - Erwartete und beobachtete Arten-Durchmischung. Forstwiss Centralbl, 116:129-139, 1997.

Rajala, Illian: Graph-based description of mingling and segregation in multitype spatial point patterns. To appear 2011.
}

\keyword{ package }
