\name{spatstat.options}
\alias{spatstat.options}
\alias{reset.spatstat.options}
\title{Internal Options in Spatstat Package}
\description{
  Allows the user to examine and reset the values
  of global parameters which control actions in the
  \pkg{spatstat} package.
}
\usage{
  spatstat.options(...)
  reset.spatstat.options()
}
\arguments{
  \item{\dots}{
    Either empty,
    or a succession of parameter names in quotes,
    or a succession of \code{name=value} pairs.
    See below for the parameter names.
  }
}
\value{
  Either a list of parameters and their values,
  or a single value. See Details.
}
\details{
  The function \code{spatstat.options}
  allows the user to examine and reset the values
  of global parameters which control actions in the
  \pkg{spatstat} package.
  It is analogous to the system function \code{\link{options}}.

  The function \code{reset.spatstat.options} resets all the
  global parameters in \pkg{spatstat} to their original,
  default values.
  
  The global parameters are:
  \describe{
    \item{npixel}{
      Controls the number of pixels in the discrete approximation
      of an irregular window by a binary pixel image as created by
      \code{\link{as.mask}}. Either an integer or a pair of integers
      giving the number of pixels in the \code{x} and \code{y}
      directions.
    }
    \item{maxedgewt}{
      Edge correction weights will be trimmed
      so as not to exceed this value.
      This applies to the weights computed by
      \code{\link{edge.Trans}} or \code{\link{edge.Ripley}}
      and used in \code{\link{Kest}} and its relatives.
    }
    \item{par.binary}{
      List of arguments to be passed to the function \code{\link{image}}
      when displaying a binary image mask (in \code{\link{plot.owin}}
      or \code{\link{plot.ppp}}).
      Typically used to reset the colours of foreground and background.
    }
    \item{par.persp}{
      List of arguments to be passed to the function \code{\link{persp}}
      when displaying a real-valued image, such as the fitted surfaces
      in \code{\link{plot.ppm}}.
    }
    \item{par.points}{
      List of arguments controlling the plotting of point patterns
      by \code{\link{plot.ppp}}.
    }
    \item{par.contour}{
      List of arguments controlling contour plots of pixel images
      by \code{\link{contour.im}}.
    }
    \item{ndummy.min}{
      Controls the number of dummy points in a quadrature scheme
      created by \code{\link{default.dummy}}.
      Either an integer or a pair of integers
      giving the number of dummy points in the \code{x} and \code{y}
      directions. 
    }
    \item{image.colfun}{
      Function determining the default colour map for
      \code{\link{plot.im}}. When called with one integer argument
      \code{n}, this function should return a character vector of length
      \code{n} specifying \code{n} different colours.
    }
    \item{progress}{
      Character string determining the style of progress reports
      printed by \code{\link{progressreport}}. Either
      \code{"tty"} or \code{"txtbar"}.
    }
    \item{checkpolygons}{
      Logical flag indicating whether the functions
      \code{\link{owin}} and \code{\link{as.owin}} should check
      the validity of polygon data. It is advisable to leave this
      set to \code{TRUE}. If you set \code{checkpolygons=FALSE},
      no checking will be performed, making it possible to create
      window objects whose topology is garbled. This can be useful
      for inspecting spatial data that contain errors,
      for example, when converting data from shapefiles.
      However, other functions in \pkg{spatstat} may return
      incorrect answers on these data.
    }
    \item{checksegments}{
      Logical flag indicating whether the functions
      \code{\link{psp}} and \code{\link{as.psp}} should check
      the validity of line segment data (in particular, checking that
      the endpoints of the line segments are inside the specified
      window). It is advisable to leave this flag set to \code{TRUE}. 
    }
    \item{gpclib}{
      Logical flag indicating whether the polygon clipping library
      \code{gpclib} can be used. Default is \code{TRUE}. If it is set to
      \code{FALSE} then certain polygon operations such as
      intersection and union will be approximated by raster operations.
      The licence
      for \code{gpclib} is not Free Open Source and explicitly forbids
      commercial use. See \code{library(help=gpclib)}. If you are using
      \code{spatstat} for commercial purposes you will need to set
      this option to \code{FALSE}.
    }
    \item{maxmatrix}{
      The maximum permitted size (rows times columns)
      of matrices generated by \pkg{spatstat}'s internal code.
      Used by \code{\link{ppm}} and \code{\link{predict.ppm}}
      (for example) to decide when to
      split a large calculation into blocks.
      Defaults to \code{2^24=16777216}. 
    }
    \item{huge.npoints}{
      The maximum value of \code{n} for which \code{runif(n)} will
      not generate an error (possible errors include failure to allocate
      sufficient memory, and integer overflow of \code{n}).
      An attempt to generate more than this number of random points
      triggers a warning from \code{\link{runifpoint}} and other
      functions. Defaults to \code{1e6}.
    }
    \item{expand}{
      The default expansion factor (area inflation factor)
      for expansion of the simulation window in
      \code{\link{rmh}} (see \code{\link{rmhcontrol}}).
      Initialised to \code{2}.
    }
  }
  If no arguments are given, 
  the current values of all parameters are returned,
  in a list.

  If one parameter name is given, the current value of this
  parameter is returned (\bold{not} in a list, just the value).
  
  If several parameter names are given,
  the current values of these parameters are returned, in a list.
  
  If \code{name=value} pairs are given, the named parameters
  are reset to the given values, and the \bold{previous} values of
  these parameters are returned, in a list.
}
\seealso{
  \code{\link{options}}
}
\examples{
  spatstat.options()

  spatstat.options("npixel")
  spatstat.options(npixel=150)
  spatstat.options(npixel=c(100,200))

  spatstat.options(par.binary=list(col=grey(c(0.5,1))))

  spatstat.options(par.persp=list(theta=-30,phi=40,d=4))
  # see help(persp.default) for other options

}
\author{Adrian Baddeley
  \email{Adrian.Baddeley@csiro.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
  and Rolf Turner
  \email{r.turner@auckland.ac.nz}
}
\keyword{spatial}
