% Generated by roxygen2 (4.0.1): do not edit by hand
\name{predict.mcmcspatsurv}
\alias{predict.mcmcspatsurv}
\title{predict.mcmcspatsurv function}
\usage{
\method{predict}{mcmcspatsurv}(object, type = "density", t = NULL,
  n = 110, indx = NULL, probs = c(0.025, 0.5, 0.975), plot = TRUE,
  pause = TRUE, ...)
}
\arguments{
\item{object}{an object of class mcmcspatsurv}

\item{type}{can be "density", "hazard", "survival" or "densityquantile". Default is "density". Note that "densityquantile" is not always analytically tractable for some choices of baseline hazard function.}

\item{t}{optional vector of times at which to compute the quantiles, Defult is NULL, in which case a uniformly spaced vector of length n from 0 to the maximum time is used}

\item{n}{the number of points at which to compute the quantiles if t is NULL}

\item{indx}{the index number of a particular individual or vector of indices of individuals for which the quantiles should be produced}

\item{probs}{vector of probabilities}

\item{plot}{whether to plot the result}

\item{pause}{logical whether to pause between plots, the default is TRUE}

\item{...}{other arguments, not used here}
}
\value{
the required predictions
}
\description{
A function to produce predictions from MCMC output. These could include quantiles of the individual density, survival or
hazard functions or quantiles of the density function (if available analytically).
}
\seealso{
\link{print.mcmcspatsurv}, \link{quantile.mcmcspatsurv}, \link{summary.mcmcspatsurv}, \link{vcov.mcmcspatsurv},
\link{frailtylag1}, \link{spatialpars}, \link{hazardpars}, \link{fixedpars}, \link{randompars},
\link{baselinehazard}, \link{priorposterior}, \link{posteriorcov}, \link{MCE},
\link{hazardexceedance}
}

