% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PCA.R
\name{pca}
\alias{pca}
\title{Computes principal components solutions}
\usage{
pca(S, nd, only.values = FALSE, screeplot = FALSE, kaiser.print = FALSE)
}
\arguments{
\item{S}{A correlation or covariance matrix.}

\item{nd}{Integer: number of loadings to retain. If missing all loadings are
retained.}

\item{only.values}{Logical: should only the eigenvalues be computed?}

\item{screeplot}{Logical: should the screeplot be plotted?}

\item{kaiser.print}{Logical: should the kaiser rule be computed, printed and
returned?.}
}
\value{
An object of class \emph{spca} is returned, which contains:
\item{loadings}{The matrix of loadings (if only.values = TRUE it is equal to
NULL).} \item{vexpv}{a vector of variances explained by each PC}
\item{vexp}{a vector of variances explained by each PC} \item{cvexp}{a
vector of cumulative variances explained by the PCs} In addition, if
\code{kaiser.print = TRUE}: \item{kaiser}{The number of eigenvalues larger
than one.}
}
\description{
Computes PCA components loadings.
}
\details{
\emph{nd} is just the number of components retained from the full eigen
decomposition, doesn't speed up the function. \emph{only.values} does not
compute the loadings and is more efficient. Kaiser rule determines the
number of components as the number of eigenvalues larger than one. It should
be used only for correlation matrices, if called on a covariance matrix a
warning is generated.
}
\examples{
\dontrun{
	 data(anthrop, package = "spca")
	 # computes 4 PCs loadings plotting the screeplot and printing the kaiser rule
	 mypca <- pca(anthrop, nd = 4, screeplot = TRUE, kaiser.print = TRUE)
	 ## print loadings
	 mypca
	 summary(mypca)
 }
}
\seealso{
See also \code{\link{print.spca}, \link{summary.spca}}
}

