% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data-docs.R
\docType{data}
\name{bscoup}
\alias{bscoup}
\title{B&S 2003 coup data}
\format{A data frame with 5828 observations of 9 variables:
\describe{
 \item{\code{countryid}}{Gleditsch and Ward country codes.}
 \item{\code{year}}{Year}
 \item{\code{couprisk}}{Structural coup risk index, see paper for details.}
 \item{\code{recentcoups}}{Alternative coup risk measure, running count of coups in past 10 years.}
 \item{\code{rwar}}{Country participated in war in past 10 years.}
 \item{\code{milreg}}{1=Military regime, 0=other}
 \item{\code{wealth}}{log of GDP per capita}
 \item{\code{instab}}{Domestic instability and violence.}
 \item{\code{coup}}{Indicator for successful coup.}
 \item{\code{africa}}{Indicator for countries in Africa.}
 \item{\code{eurnam}}{Indicator for countries in Europe and N. America.}
 \item{\code{samerica}}{Indicator for countries in South America.}
 \item{\code{camerica}}{Indicator for countries in Central America.}
 \item{\code{regconf}}{Regional conflict.}
}}
\source{
Belkin, Aaron and Evan Schofer. 2003. ``Toward a structural understanding of
coup risk.'' Journal of Conflict Resolution Vol. 47 No. 5.
}
\usage{
bscoups
}
\description{
Replication data from Belkin and Schofer's 2003 paper on coups.
}
\examples{
data(bscoup)
table(bscoup$coup)
range(bscoup$year)
}
\keyword{datasets}

