% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SilhouetR.R
\name{SilhouetR}
\alias{SilhouetR}
\title{SilhouetR}
\usage{
SilhouetR(DataMatrix, GroupIndices, distance = "euclidean")
}
\arguments{
\item{DataMatrix}{a matrix with the raw data, 1 variable per column.}

\item{GroupIndices}{The vector with the group indices (length must be equal to the amount of rows in DataMatrix).}

\item{distance}{The distance metric to be used, "euclidean" or "manhattan".}
}
\value{
Returns the silhouette values. Note if a group contains only 1 no Silhouette value can be calculated (will give NA)
}
\description{
This function calculate Silhouette values. The function is generic, 
as such silhouette values can be calculated between samples of different classes or 
it can be used to calculate silhouette values between different groups of peaks. 
This is the way in which it is used for the speaq package (see the example).
}
\examples{
subset <- GetWinedata.subset()
# to reduce the example time we only select spectra 1 & 2
subset.spectra = as.matrix(subset$Spectra)[1:2,] 
subset.ppm = as.numeric(subset$PPM)

test.peaks <- getWaveletPeaks(Y.spec=subset.spectra, 
                              X.ppm=subset.ppm,
                              nCPU = 1) # nCPU set to 2 for the vignette build
                              
test.grouped <- PeakGrouper(Y.peaks = test.peaks)

Silhouette.values = SilhouetR(DataMatrix = test.grouped$peakPPM, 
                              test.grouped$peakIndex, 
                              distance = "euclidean")
                              
hist(Silhouette.values$SilhouetteValues)


}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}
