% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R, R/alignmentFunctions.R
\docType{methods}
\name{wavelengthAlign}
\alias{wavelengthAlign}
\alias{wavelengthAlign,SpectraInTime,SpectraInTime-method}
\alias{wavelengthAlign,SpectraInTime,list-method}
\title{Align SpectraInTime objects with differing wavelength axes to a common wavelength axis 
using cubic spline interpolation.}
\usage{
wavelengthAlign(ref, toAlign)

\S4method{wavelengthAlign}{SpectraInTime,SpectraInTime}(ref, toAlign)

\S4method{wavelengthAlign}{SpectraInTime,list}(ref, toAlign)
}
\arguments{
\item{ref}{\code{\link{SpectraInTime-class}} object with the reference wavelength vector}

\item{toAlign}{\code{\link{SpectraInTime-class}} object(s) to be aligned. This can either be a single SpectraInTime object
or a list of SpectraInTime objects. In case of a list, all objects in the list should have the same wavelength axis.}
}
\value{
List of aligned SpectraInTime objects, including the reference object.
}
\description{
Align SpectraInTime objects with differing wavelength axes to a common wavelength axis 
using cubic spline interpolation.
}
