/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.table.model.twodim;

import at.ac.ait.speedr.table.RColumnIndexModel;
import javax.swing.table.AbstractTableModel;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.RList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RStringMatrixTableModel
extends AbstractTableModel
implements RColumnIndexModel {
    private int nrow;
    private int ncol;
    private String[][] stringMatrix;
    private String[] rownames;
    private String[] columnnames;

    public RStringMatrixTableModel(REXPString data) throws REXPMismatchException {
        int[] dim = data.dim();
        if (dim.length == 1) {
            this.nrow = dim[0];
            this.ncol = 1;
        } else if (dim.length == 2) {
            this.nrow = dim[0];
            this.ncol = dim[1];
        } else {
            throw new RuntimeException("wrong dimension: " + dim.length);
        }
        this.setStringMatrix(data.asStrings());
        this.setRowAndColumnNames((REXP)data);
        this.ncol += this.rownames != null ? 1 : 0;
    }

    private void setStringMatrix(String[] data) {
        this.stringMatrix = new String[this.nrow][this.ncol];
        int k = 0;
        for (int i = 0; i < this.ncol; ++i) {
            int j = 0;
            while (j < this.nrow) {
                this.stringMatrix[j++][i] = data[k++];
            }
        }
    }

    private void setRowAndColumnNames(REXP data) throws REXPMismatchException {
        RList dimnames;
        REXP attribute = data.getAttribute("dimnames");
        if (attribute != null && !attribute.isNull() && (dimnames = data.getAttribute("dimnames").asList()) != null && !dimnames.isEmpty()) {
            this.rownames = dimnames.at(0).asStrings();
            if (dimnames.size() == 2) {
                this.columnnames = dimnames.at(1).asStrings();
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.nrow;
    }

    @Override
    public int getColumnCount() {
        return this.ncol;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        if (this.rownames != null && column == 0) {
            return "dimnames[[1]]";
        }
        if (this.rownames != null) {
            --column;
        }
        if (this.columnnames != null) {
            return this.columnnames[column];
        }
        return "" + (column + 1);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.rownames != null && columnIndex == 0) {
            return this.rownames[rowIndex];
        }
        if (this.rownames != null) {
            --columnIndex;
        }
        return this.stringMatrix[rowIndex][columnIndex];
    }

    @Override
    public String getColumnIndexCode(int columnIndex) {
        if (this.getColumnName(columnIndex).matches("\\d+")) {
            return "[," + this.getColumnName(columnIndex) + "]";
        }
        return "[,\"" + this.getColumnName(columnIndex) + "\"]";
    }

    @Override
    public String getRownameIndexCode(String var) {
        return "dimnames(" + var + ")[[1]]";
    }
}

