/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.importwizard.steps;

import at.ac.ait.speedr.importwizard.WizardPanel;
import at.ac.ait.speedr.importwizard.steps.DataSourcePanel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DataSourceWizardStep
implements WizardPanel.Step,
PropertyChangeListener {
    public static final String PROP_EXTENSION = "PROP_EXTENSION";
    public static final String PROP_FILE = "PROP_FILE";
    public static final String PROP_URL_TO_DATA = "PROP_URL_TO_DATA";
    public static final String PROP_PASTED_DATA = "PROP_PASTED_DATA";
    public static final String PROP_DATASOURCE = "PROP_DATASOURCE";
    private DataSourcePanel dataSourcePanel;
    private WizardPanel settings;
    private boolean isValid = false;
    private File selectedFile;
    private String pastedData;
    private URL url;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public JPanel getComponent() {
        if (this.dataSourcePanel == null) {
            this.dataSourcePanel = new DataSourcePanel();
            this.dataSourcePanel.addPropertyChangeListener(this);
        }
        return this.dataSourcePanel;
    }

    public void readSettings(WizardPanel settings) {
        this.settings = settings;
    }

    public void storeSettings(WizardPanel settings) {
        if (this.dataSourcePanel.getCurrentDataSource() == "PROP_FILE_DATASOURCE") {
            settings.putProperty(PROP_DATASOURCE, "PROP_FILE_DATASOURCE");
            int index = this.selectedFile.getName().lastIndexOf(46);
            if (index == -1) {
                settings.putProperty(PROP_EXTENSION, "txt");
            } else {
                settings.putProperty(PROP_EXTENSION, this.selectedFile.getName().substring(index + 1));
            }
            settings.putProperty(PROP_FILE, this.selectedFile);
        } else if (this.dataSourcePanel.getCurrentDataSource() == "PROP_PASTEDATA_DATASOURCE") {
            settings.putProperty(PROP_DATASOURCE, "PROP_PASTEDATA_DATASOURCE");
            settings.putProperty(PROP_PASTED_DATA, this.pastedData);
            settings.putProperty(PROP_EXTENSION, "txt");
        } else if (this.dataSourcePanel.getCurrentDataSource() == "PROP_URL_DATASOURCE") {
            settings.putProperty(PROP_DATASOURCE, "PROP_URL_DATASOURCE");
            settings.putProperty(PROP_URL_TO_DATA, this.url);
            String urlText = this.url.toString();
            int index = urlText.lastIndexOf(46);
            if (index == -1) {
                settings.putProperty(PROP_EXTENSION, "txt");
            } else {
                settings.putProperty(PROP_EXTENSION, urlText.substring(index + 1));
            }
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "SelectedFileChangedProperty") {
            this.selectedFile = this.dataSourcePanel.getSelectedFile();
            this.checkValidity(this.selectedFile, "Please select a file!");
        } else if (evt.getPropertyName() == "PROP_PASTE_DATA_CHANGED") {
            this.pastedData = evt.getNewValue().toString();
            if (this.pastedData.length() == 0) {
                this.pastedData = null;
            }
            this.checkValidity(this.pastedData, "Please write or paste some data on the text area!");
        } else if (evt.getPropertyName() == "PROP_URL_CHANGED") {
            this.checkURL(evt);
            this.checkValidity(this.url, "URL is not valid!");
        } else if (evt.getPropertyName() == "PROP_DATASOURCE_CHANGED") {
            if (evt.getNewValue() == "PROP_FILE_DATASOURCE") {
                this.checkValidity(this.selectedFile, "Please select a file!");
            } else if (evt.getNewValue() == "PROP_PASTEDATA_DATASOURCE") {
                this.checkValidity(this.pastedData, "Please write or paste some data on the text area!");
            } else if (evt.getNewValue() == "PROP_URL_DATASOURCE") {
                this.checkValidity(this.url, "URL is not valid!");
            }
        }
    }

    private void checkValidity(Object data, String message) {
        if (data == null) {
            this.isValid = false;
            this.setMessage(message);
        } else {
            this.isValid = true;
            this.setMessage(null);
        }
        this.fireChangeEvent();
    }

    private void checkURL(PropertyChangeEvent evt) {
        try {
            this.url = new URL(evt.getNewValue().toString());
        }
        catch (MalformedURLException ex) {
            this.url = null;
        }
    }

    private void setMessage(String message) {
        this.settings.putProperty("WizardPanel_errorMessage", message);
    }
}

