/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.flat;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.themes.color.DisplayerColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class FlatBorder
implements Border {
    private static final float FACTOR = 0.85f;
    private DockableDisplayer owner;
    private BorderColor background = new BorderColor("displayer.border");
    private BorderColor light = new BorderColor("displayer.border.light");
    private BorderColor dark = new BorderColor("displayer.border.dark");
    private BorderColor middle = new BorderColor("displayer.border.middle");

    public FlatBorder(DockableDisplayer owner) {
        this.owner = owner;
    }

    public void connect(DockController controller) {
        this.background.connect(controller);
        this.light.connect(controller);
        this.dark.connect(controller);
        this.middle.connect(controller);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color background = (Color)this.background.value();
        Color light = (Color)this.light.value();
        Color middle = (Color)this.middle.value();
        Color dark = (Color)this.dark.value();
        if (background == null) {
            background = c.getBackground();
        }
        if (light == null) {
            light = this.darker(background);
        }
        if (middle == null) {
            middle = this.darker(light);
        }
        if (dark == null) {
            dark = this.darker(middle);
        }
        g.setColor(dark);
        g.drawRect(x, y, width - 3, height - 3);
        g.setColor(middle);
        g.drawLine(x + width - 2, y + 1, x + width - 2, y + height - 3);
        g.drawLine(x + width - 3, y, x + width - 3, y);
        g.drawLine(x, y + height - 3, x, y + height - 3);
        g.drawLine(x + 1, y + height - 2, x + width - 3, y + height - 2);
        g.setColor(light);
        g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 2);
        g.drawLine(x + width - 2, y, x + width - 2, y);
        g.drawLine(x, y + height - 2, x, y + height - 2);
        g.drawLine(x + 1, y + height - 1, x + width - 2, y + height - 1);
        g.drawLine(x + width - 2, y + height - 2, x + width - 2, y + height - 2);
    }

    private Color darker(Color c) {
        return new Color(Math.max((int)((float)c.getRed() * 0.85f), 0), Math.max((int)((float)c.getGreen() * 0.85f), 0), Math.max((int)((float)c.getBlue() * 0.85f), 0));
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(1, 1, 3, 3);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    private class BorderColor
    extends DisplayerColor {
        public BorderColor(String id) {
            super(id, FlatBorder.this.owner, null);
        }

        protected void changed(Color oldColor, Color newColor) {
            FlatBorder.this.owner.getComponent().repaint();
        }
    }
}

