/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.event.DockableAdapter;
import bibliothek.gui.dock.event.DockableListener;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.screen.DisplayerScreenDockWindow;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.ScreenDockWindowBorder;
import bibliothek.gui.dock.station.screen.ScreenDockWindowDockBorder;
import bibliothek.gui.dock.station.screen.ScreenDockWindowListener;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.themes.border.BorderForwarder;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class AbstractScreenDockWindow
extends DisplayerScreenDockWindow {
    private Component window;
    private DockableDisplayer displayer;
    private SecureContainer content;
    private CombinerTarget combination;
    private Icon titleIcon = null;
    private String titleText = null;
    private BackgroundAlgorithm background;
    private BackgroundPanel contentBackground;
    private ScreenDockWindowBorder border;
    private WindowBorder borderModifier;
    private DockableListener listener = new DockableAdapter(){

        public void titleIconChanged(Dockable dockable, Icon oldIcon, Icon newIcon) {
            AbstractScreenDockWindow.this.updateTitleIcon();
        }

        public void titleTextChanged(Dockable dockable, String oldTitle, String newTitle) {
            AbstractScreenDockWindow.this.updateTitleText();
        }
    };
    private ScreenDockWindowListener windowListener = new ScreenDockWindowListener(){
        private boolean remembered = false;

        public void visibilityChanged(ScreenDockWindow window) {
            if (AbstractScreenDockWindow.this.isFullscreen() != this.remembered) {
                AbstractScreenDockWindow.this.fireFullscreenChanged();
            }
        }

        public void shapeChanged(ScreenDockWindow window) {
            if (AbstractScreenDockWindow.this.isFullscreen() != this.remembered) {
                AbstractScreenDockWindow.this.fireFullscreenChanged();
            }
        }

        public void fullscreenStateChanged(ScreenDockWindow window) {
            this.remembered = AbstractScreenDockWindow.this.isFullscreen();
        }
    };

    protected AbstractScreenDockWindow(ScreenDockStation station) {
        super(station);
    }

    public AbstractScreenDockWindow(ScreenDockStation station, Component window, Container contentParent, boolean resizeable) {
        super(station);
        this.init(window, contentParent, resizeable);
    }

    protected void init(Component window, Container contentParent, boolean resizeable) {
        if (window == null) {
            throw new IllegalArgumentException("window must not be null");
        }
        if (contentParent == null) {
            throw new IllegalArgumentException("contentParent must not be null");
        }
        this.window = window;
        this.content = this.createContent();
        this.content.setController(this.getController());
        contentParent.setLayout(new GridLayout(1, 1));
        contentParent.add(this.content);
        Container parent = this.getDisplayerParent();
        parent.setLayout(new GridLayout(1, 1));
        if (resizeable) {
            if (parent instanceof JComponent) {
                this.border = new ScreenDockWindowBorder(this, (JComponent)parent);
                this.border.setController(this.getController());
                this.borderModifier = new WindowBorder((JComponent)parent);
                this.borderModifier.setBorder(this.border);
                this.borderModifier.setController(this.getController());
                ((JComponent)parent).setBorder(this.border);
            }
            Listener listener = new Listener();
            parent.addMouseListener(listener);
            parent.addMouseMotionListener(listener);
            parent.addComponentListener(listener);
        }
        window.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                AbstractScreenDockWindow.this.fireShapeChanged();
            }

            public void componentMoved(ComponentEvent e) {
                AbstractScreenDockWindow.this.fireShapeChanged();
            }
        });
        this.addScreenDockWindowListener(this.windowListener);
    }

    public void setController(DockController controller) {
        super.setController(controller);
        this.content.setController(controller);
        if (this.border != null) {
            this.border.setController(controller);
        }
        if (this.borderModifier != null) {
            this.borderModifier.setController(controller);
        }
    }

    protected Component getWindowComponent() {
        return this.window;
    }

    protected void setBackground(BackgroundAlgorithm background) {
        this.background = background;
        if (this.contentBackground != null) {
            this.contentBackground.setBackground(background);
        }
        this.window.repaint();
    }

    public void setDockable(Dockable dockable) {
        Dockable old = this.getDockable();
        if (old != null) {
            old.removeDockableListener(this.listener);
        }
        super.setDockable(dockable);
        if (dockable != null) {
            dockable.addDockableListener(this.listener);
        }
        this.updateTitleIcon();
        this.updateTitleText();
    }

    protected void showDisplayer(DockableDisplayer displayer) {
        if (this.displayer != displayer) {
            if (this.displayer != null) {
                this.getDisplayerParent().remove(this.displayer.getComponent());
            }
            this.displayer = displayer;
            if (displayer != null) {
                this.getDisplayerParent().add(displayer.getComponent());
            }
        }
        this.validate();
    }

    public void setTitleIcon(Icon titleIcon) {
        this.titleIcon = titleIcon;
        this.updateTitleIcon();
    }

    protected Icon getTitleIcon() {
        if (this.titleIcon != null) {
            return this.titleIcon;
        }
        Dockable dockable = this.getDockable();
        if (dockable == null) {
            return null;
        }
        return dockable.getTitleIcon();
    }

    protected void updateTitleIcon() {
    }

    public void setTitleText(String titleText) {
        this.titleText = titleText;
        this.updateTitleText();
    }

    protected String getTitleText() {
        if (this.titleText != null) {
            return this.titleText;
        }
        Dockable dockable = this.getDockable();
        if (dockable == null) {
            return null;
        }
        return dockable.getTitleText();
    }

    protected void updateTitleText() {
    }

    public Rectangle getWindowBounds() {
        return this.window.getBounds();
    }

    public void setPaintCombining(CombinerTarget target) {
        this.combination = target;
        this.window.repaint();
    }

    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            this.window.setVisible(visible);
            this.fireVisibilityChanged();
        }
    }

    public boolean isVisible() {
        return this.window.isVisible();
    }

    public void setWindowBounds(Rectangle bounds, boolean screenCoordinates) {
        Rectangle valid = this.getStation().getBoundaryRestriction().check(this, bounds);
        if (valid != null) {
            this.window.setBounds(valid);
        } else {
            this.window.setBounds(bounds);
        }
        this.invalidate();
        this.validate();
    }

    public void checkWindowBounds() {
        Rectangle valid = this.getStation().getBoundaryRestriction().check(this);
        if (valid != null) {
            this.window.setBounds(valid);
        }
    }

    public void invalidate() {
        this.window.invalidate();
    }

    public void validate() {
        this.window.validate();
    }

    protected void setCursor(Cursor cursor) {
        this.window.setCursor(cursor);
    }

    protected void convertPointToScreen(Point point, Component component) {
        SwingUtilities.convertPointToScreen(point, component);
    }

    public Insets getDockableInsets() {
        Container parent = this.getDisplayerParent();
        Insets parentInsets = parent.getInsets();
        if (parentInsets == null) {
            parentInsets = new Insets(0, 0, 0, 0);
        }
        Point zero = new Point(0, 0);
        zero = SwingUtilities.convertPoint(parent, zero, this.window);
        parentInsets.left += zero.x;
        parentInsets.top += zero.y;
        parentInsets.right += this.window.getWidth() - parent.getWidth() - zero.x;
        parentInsets.bottom += this.window.getHeight() - parent.getHeight() - zero.y;
        if (this.displayer == null) {
            return parentInsets;
        }
        Insets insets = this.displayer.getDockableInsets();
        parentInsets.top += insets.top;
        parentInsets.bottom += insets.bottom;
        parentInsets.left += insets.left;
        parentInsets.right += insets.right;
        return parentInsets;
    }

    protected SecureContainer createContent() {
        this.contentBackground = new BackgroundPanel(true, false);
        this.contentBackground.setBackground(this.background);
        SecureContainer panel = new SecureContainer(){

            protected void paintOverlay(Graphics g) {
                ScreenDockStation station;
                StationPaint paint;
                if (AbstractScreenDockWindow.this.combination != null && (paint = (StationPaint)(station = AbstractScreenDockWindow.this.getStation()).getPaint().get()) != null) {
                    Insets insets = this.getInsets();
                    Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    Rectangle insert = new Rectangle(2 * insets.left, 2 * insets.top, this.getWidth() - 2 * (insets.left + insets.right), this.getHeight() - 2 * (insets.top + insets.bottom));
                    AbstractScreenDockWindow.this.combination.paint(g, AbstractScreenDockWindow.this.contentBackground, paint, bounds, insert);
                }
            }
        };
        panel.setContentPane(this.contentBackground);
        panel.getBasePane().setLayout(new BorderLayout());
        panel.getBasePane().add((Component)this.contentBackground, "Center");
        return panel;
    }

    protected Container getDisplayerParent() {
        return this.content.getContentPane();
    }

    public DockableDisplayer getDisplayer() {
        return this.displayer;
    }

    private class Listener
    implements MouseListener,
    MouseMotionListener,
    ComponentListener {
        private boolean pressed = false;
        private ScreenDockWindowBorder.Position position = ScreenDockWindowBorder.Position.NOTHING;
        private Point start;
        private Rectangle bounds;

        private Listener() {
        }

        private void updateBorder() {
            if (AbstractScreenDockWindow.this.border != null) {
                if (this.pressed) {
                    AbstractScreenDockWindow.this.border.setMousePressed(this.position);
                    AbstractScreenDockWindow.this.border.setMouseOver(null);
                } else {
                    AbstractScreenDockWindow.this.border.setMousePressed(null);
                    AbstractScreenDockWindow.this.border.setMouseOver(this.position);
                }
                AbstractScreenDockWindow.this.border.setCornerSize(this.corner());
                AbstractScreenDockWindow.this.border.setMoveSize(AbstractScreenDockWindow.this.getDisplayerParent().getWidth() / 3);
            }
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            this.updateBorder();
        }

        public void componentShown(ComponentEvent e) {
        }

        private int corner() {
            Container component = AbstractScreenDockWindow.this.getDisplayerParent();
            Insets insets = component.getInsets();
            int corner = Math.max(Math.max(insets.top, insets.bottom), Math.max(insets.left, insets.right)) * 5;
            corner = Math.max(25, Math.min(50, corner));
            corner = Math.min(Math.min(component.getHeight() / 2, component.getWidth() / 3), corner);
            return corner;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.updateCursor(e);
            if (!this.pressed && e.getButton() == 1) {
                this.pressed = true;
                this.start = e.getPoint();
                AbstractScreenDockWindow.this.convertPointToScreen(this.start, e.getComponent());
                this.bounds = AbstractScreenDockWindow.this.getWindowBounds();
                this.updateBorder();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (this.pressed && e.getButton() == 1) {
                this.pressed = false;
                this.updateCursor(e);
                AbstractScreenDockWindow.this.checkWindowBounds();
                AbstractScreenDockWindow.this.invalidate();
                AbstractScreenDockWindow.this.validate();
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (!this.pressed && e.getButton() == 0) {
                this.updateCursor(e);
                this.position = ScreenDockWindowBorder.Position.NOTHING;
            }
        }

        public void mouseExited(MouseEvent e) {
            if (!this.pressed && e.getButton() == 0) {
                AbstractScreenDockWindow.this.setCursor(Cursor.getDefaultCursor());
                this.position = ScreenDockWindowBorder.Position.NOTHING;
                this.updateBorder();
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.pressed) {
                Point point = e.getPoint();
                AbstractScreenDockWindow.this.convertPointToScreen(point, e.getComponent());
                int dx = point.x - this.start.x;
                int dy = point.y - this.start.y;
                Rectangle bounds = new Rectangle(this.bounds);
                int min = 25;
                if (this.position == ScreenDockWindowBorder.Position.N || this.position == ScreenDockWindowBorder.Position.NE || this.position == ScreenDockWindowBorder.Position.NW) {
                    bounds.height -= dy;
                    bounds.y += dy;
                    if (bounds.height < min) {
                        bounds.y -= min - bounds.height;
                        bounds.height = min;
                    }
                }
                if (this.position == ScreenDockWindowBorder.Position.E || this.position == ScreenDockWindowBorder.Position.NE || this.position == ScreenDockWindowBorder.Position.SE) {
                    bounds.width += dx;
                    if (bounds.width < min) {
                        bounds.width = min;
                    }
                }
                if (this.position == ScreenDockWindowBorder.Position.S || this.position == ScreenDockWindowBorder.Position.SE || this.position == ScreenDockWindowBorder.Position.SW) {
                    bounds.height += dy;
                    if (bounds.height < min) {
                        bounds.height = min;
                    }
                }
                if (this.position == ScreenDockWindowBorder.Position.W || this.position == ScreenDockWindowBorder.Position.SW || this.position == ScreenDockWindowBorder.Position.NW) {
                    bounds.width -= dx;
                    bounds.x += dx;
                    if (bounds.width < min) {
                        bounds.x -= min - bounds.width;
                        bounds.width = min;
                    }
                }
                if (this.position == ScreenDockWindowBorder.Position.MOVE) {
                    bounds.x += dx;
                    bounds.y += dy;
                }
                AbstractScreenDockWindow.this.setWindowBounds(bounds, false);
                this.updateBorder();
                AbstractScreenDockWindow.this.invalidate();
                AbstractScreenDockWindow.this.validate();
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (!this.pressed && e.getButton() == 0) {
                this.updateCursor(e);
            }
        }

        private void updateCursor(MouseEvent e) {
            boolean valid;
            Container component = AbstractScreenDockWindow.this.getDisplayerParent();
            Insets insets = component.getInsets();
            boolean bl = valid = e.getComponent() == component && e.getY() <= insets.top || e.getY() >= component.getHeight() - insets.bottom || e.getX() <= insets.left || e.getX() >= component.getWidth() - insets.right;
            if (valid) {
                boolean right;
                int corner = this.corner();
                boolean top = e.getY() <= corner;
                boolean left = e.getX() <= corner;
                boolean bottom = e.getY() >= component.getHeight() - corner;
                boolean bl2 = right = e.getX() >= component.getWidth() - corner;
                if (top && left) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(6));
                    this.position = ScreenDockWindowBorder.Position.NW;
                } else if (top && right) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(7));
                    this.position = ScreenDockWindowBorder.Position.NE;
                } else if (bottom && right) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(5));
                    this.position = ScreenDockWindowBorder.Position.SE;
                } else if (bottom && left) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(4));
                    this.position = ScreenDockWindowBorder.Position.SW;
                } else if (top) {
                    int width = component.getWidth();
                    if (e.getX() > width / 3 && e.getX() < width / 3 * 2) {
                        AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(13));
                        this.position = ScreenDockWindowBorder.Position.MOVE;
                    } else {
                        AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(8));
                        this.position = ScreenDockWindowBorder.Position.N;
                    }
                } else if (bottom) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(9));
                    this.position = ScreenDockWindowBorder.Position.S;
                } else if (left) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(10));
                    this.position = ScreenDockWindowBorder.Position.W;
                } else if (right) {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getPredefinedCursor(11));
                    this.position = ScreenDockWindowBorder.Position.E;
                } else {
                    AbstractScreenDockWindow.this.setCursor(Cursor.getDefaultCursor());
                    this.position = ScreenDockWindowBorder.Position.NOTHING;
                }
            } else {
                AbstractScreenDockWindow.this.setCursor(Cursor.getDefaultCursor());
                this.position = ScreenDockWindowBorder.Position.NOTHING;
            }
            this.updateBorder();
        }
    }

    private class WindowBorder
    extends BorderForwarder
    implements ScreenDockWindowDockBorder {
        public WindowBorder(JComponent target) {
            super(ScreenDockWindowDockBorder.KIND, "dock.border.screen.window", target);
        }

        public ScreenDockWindow getWindow() {
            return AbstractScreenDockWindow.this;
        }
    }
}

