/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.station;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.flap.FlapLayoutManager;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;

public class CFlapLayoutManager
implements FlapLayoutManager {
    private DockStationListener stationListener = new DockStationAdapter(){

        public void dockableAdded(DockStation station, Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                ((CommonDockable)dockable).getDockable().addCDockablePropertyListener(CFlapLayoutManager.this.propertyListener);
            }
        }

        public void dockableRemoved(DockStation station, Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                ((CommonDockable)dockable).getDockable().removeCDockablePropertyListener(CFlapLayoutManager.this.propertyListener);
            } else {
                CFlapLayoutManager.this.holds.remove(dockable);
                CFlapLayoutManager.this.sizes.remove(dockable);
            }
        }
    };
    private CDockablePropertyListener propertyListener = new CDockableAdapter(){

        public void minimizedHoldChanged(CDockable dockable) {
            DockStation parent = dockable.intern().getDockParent();
            if (parent instanceof FlapDockStation) {
                ((FlapDockStation)parent).updateHold(dockable.intern());
            }
        }

        public void minimizeSizeChanged(CDockable dockable) {
            DockStation parent = dockable.intern().getDockParent();
            if (parent instanceof FlapDockStation) {
                ((FlapDockStation)parent).updateWindowSize(dockable.intern());
            }
        }
    };
    private Map<Dockable, Boolean> holds = new HashMap<Dockable, Boolean>();
    private Map<Dockable, Integer> sizes = new HashMap<Dockable, Integer>();

    public void install(FlapDockStation station) {
        station.addDockStationListener(this.stationListener);
        int n = station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            this.stationListener.dockableAdded(station, station.getDockable(i));
        }
    }

    public void uninstall(FlapDockStation station) {
        station.removeDockStationListener(this.stationListener);
        int n = station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            this.stationListener.dockableRemoved(station, station.getDockable(i));
        }
    }

    public int getSize(FlapDockStation station, Dockable dockable) {
        FlapDockStation.Direction direction = station.getDirection();
        int size = this.getMaxSize(dockable, direction == FlapDockStation.Direction.NORTH || direction == FlapDockStation.Direction.SOUTH);
        if (size < 0) {
            Integer value = this.sizes.get(dockable);
            if (value != null) {
                return value;
            }
            return station.getDefaultWindowSize();
        }
        return size;
    }

    private int getMaxSize(Dockable dockable, boolean horizontal) {
        if (dockable instanceof CommonDockable) {
            CDockable cdock = ((CommonDockable)dockable).getDockable();
            Dimension size = cdock.getMinimizedSize();
            if (horizontal) {
                return size.width;
            }
            return size.height;
        }
        if (dockable instanceof StackDockStation) {
            StackDockStation station = (StackDockStation)dockable;
            int size = -1;
            int n = station.getDockableCount();
            for (int i = 0; i < n; ++i) {
                size = Math.max(size, this.getMaxSize(station.getDockable(i), horizontal));
            }
            return size;
        }
        return -1;
    }

    public void setSize(FlapDockStation station, Dockable dockable, int size) {
        if (dockable instanceof CommonDockable) {
            FlapDockStation.Direction direction = station.getDirection();
            boolean horizontal = direction == FlapDockStation.Direction.NORTH || direction == FlapDockStation.Direction.SOUTH;
            CDockable cdock = ((CommonDockable)dockable).getDockable();
            Dimension dimension = cdock.getMinimizedSize();
            if (horizontal) {
                cdock.setMinimizedSize(new Dimension(size, dimension.height));
            } else {
                cdock.setMinimizedSize(new Dimension(dimension.width, size));
            }
        } else {
            this.sizes.put(dockable, size);
        }
    }

    public boolean isHold(FlapDockStation station, Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable().isMinimizedHold();
        }
        return Boolean.TRUE.equals(this.holds.get(dockable));
    }

    public void setHold(FlapDockStation station, Dockable dockable, boolean hold) {
        if (dockable instanceof CommonDockable) {
            ((CommonDockable)dockable).getDockable().setMinimizedHold(hold);
        } else {
            this.holds.put(dockable, hold);
        }
    }
}

