/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DefaultDockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.actions.SimpleButtonAction;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class RenameAction
extends SimpleButtonAction {
    public static final String KEY_ICON = "rename";
    private DockController controller;
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JTextField titleField = new JTextField();
    private JPopupMenu menu = new JPopupMenu();
    private Dockable current;
    private DockActionIcon icon;
    private DockActionText text;
    private DockActionText tooltip;
    private DockActionText textOk;
    private DockActionText textCancel;
    private int bound = 0;

    public RenameAction(DockController controller) {
        this.controller = controller;
        this.icon = new DockActionIcon(KEY_ICON, this){

            protected void changed(Icon oldValue, Icon newValue) {
                RenameAction.this.setIcon(newValue);
            }
        };
        this.text = new DockActionText(KEY_ICON, this){

            protected void changed(String oldValue, String newValue) {
                RenameAction.this.setText(newValue);
            }
        };
        this.tooltip = new DockActionText("rename.tooltip", this){

            protected void changed(String oldValue, String newValue) {
                RenameAction.this.setTooltip(newValue);
            }
        };
        this.menu.setLayout(new GridBagLayout());
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add(this.okButton);
        panel.add(this.cancelButton);
        this.menu.add((Component)this.titleField, new GridBagConstraints(0, 0, 1, 1, 100.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.menu.add((Component)panel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 3, new Insets(1, 1, 1, 1), 0, 0));
        this.titleField.setColumns(10);
        this.textOk = new DockActionText("rename.ok", this){

            protected void changed(String oldValue, String newValue) {
                RenameAction.this.okButton.setText(newValue);
            }
        };
        this.textCancel = new DockActionText("rename.cancel", this){

            protected void changed(String oldValue, String newValue) {
                RenameAction.this.cancelButton.setText(newValue);
            }
        };
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
                RenameAction.this.current = null;
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RenameAction.this.rename();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RenameAction.this.menu.setVisible(false);
            }
        });
        this.titleField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RenameAction.this.rename();
            }
        });
    }

    public void action(Dockable dockable) {
        this.titleField.setText("");
        this.menu.setSize(this.menu.getPreferredSize());
        this.titleField.setText(dockable.getTitleText());
        Component component = DockUtilities.getShowingComponent(dockable);
        if (component != null) {
            this.current = dockable;
            this.menu.show(component, 0, 0);
            this.titleField.requestFocus();
        }
    }

    private void rename() {
        this.rename(this.current, this.titleField.getText());
        this.menu.setVisible(false);
    }

    protected void bound(Dockable dockable) {
        super.bound(dockable);
        if (this.bound == 0) {
            this.icon.setController(this.controller);
            this.text.setController(this.controller);
            this.tooltip.setController(this.controller);
            this.textOk.setController(this.controller);
            this.textCancel.setController(this.controller);
        }
        ++this.bound;
    }

    protected void unbound(Dockable dockable) {
        super.unbound(dockable);
        --this.bound;
        if (this.bound == 0) {
            this.icon.setController(null);
            this.text.setController(null);
            this.tooltip.setController(null);
            this.textOk.setController(null);
            this.textCancel.setController(null);
        }
    }

    protected abstract void rename(Dockable var1, String var2);

    public static class RenameDefaultDockable
    extends RenameAction {
        public RenameDefaultDockable(DockController controller) {
            super(controller);
        }

        protected void rename(Dockable dock, String text) {
            ((DefaultDockable)dock).setTitleText(text);
        }
    }

    public static class RenameFlapDockStation
    extends RenameAction {
        public RenameFlapDockStation(DockController controller) {
            super(controller);
        }

        protected void rename(Dockable dock, String text) {
            ((FlapDockStation)dock).setTitleText(text);
        }
    }

    public static class RenameSplitDockStation
    extends RenameAction {
        public RenameSplitDockStation(DockController controller) {
            super(controller);
        }

        protected void rename(Dockable dock, String text) {
            ((SplitDockStation)dock).setTitleText(text);
        }
    }

    public static class RenameStackDockStation
    extends RenameAction {
        public RenameStackDockStation(DockController controller) {
            super(controller);
        }

        protected void rename(Dockable dock, String text) {
            ((StackDockStation)dock).setTitleText(text);
        }
    }
}

