/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.doc;

import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.office.OdfOfficeSpreadsheet;

public class OdfSpreadsheetDocument
extends OdfDocument {
    private static String EMPTY_SPREADSHEET_DOCUMENT_PATH = "/OdfSpreadsheetDocument.ods";
    private static OdfDocument.Resource EMPTY_SPREADSHEET_DOCUMENT_RESOURCE = new OdfDocument.Resource(EMPTY_SPREADSHEET_DOCUMENT_PATH);

    public static OdfSpreadsheetDocument newSpreadsheetDocument() throws Exception {
        return (OdfSpreadsheetDocument)OdfDocument.loadTemplate(EMPTY_SPREADSHEET_DOCUMENT_RESOURCE);
    }

    public static OdfSpreadsheetDocument newSpreadsheetTemplateDocument() throws Exception {
        OdfSpreadsheetDocument doc = (OdfSpreadsheetDocument)OdfDocument.loadTemplate(EMPTY_SPREADSHEET_DOCUMENT_RESOURCE);
        doc.changeMode(OdfMediaType.SPREADSHEET_TEMPLATE);
        return doc;
    }

    protected OdfSpreadsheetDocument() {
    }

    public OdfOfficeSpreadsheet getContentRoot() throws Exception {
        return super.getContentRoot(OdfOfficeSpreadsheet.class);
    }

    public void changeMode(OdfMediaType type) {
        this.setMediaType(type.getOdfMediaType());
        this.getPackage().setMediaType(type.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OdfMediaType {
        SPREADSHEET(OdfDocument.OdfMediaType.SPREADSHEET),
        SPREADSHEET_TEMPLATE(OdfDocument.OdfMediaType.SPREADSHEET_TEMPLATE);

        private final OdfDocument.OdfMediaType mMediaType;

        private OdfMediaType(OdfDocument.OdfMediaType mediaType) {
            this.mMediaType = mediaType;
        }

        public String toString() {
            return this.mMediaType.toString();
        }

        public OdfDocument.OdfMediaType getOdfMediaType() {
            return this.mMediaType;
        }

        public String getName() {
            return this.mMediaType.getName();
        }

        public String getSuffix() {
            return this.mMediaType.getSuffix();
        }

        public static OdfDocument.OdfMediaType getOdfMediaType(String mediaType) {
            return OdfDocument.OdfMediaType.getOdfMediaType(mediaType);
        }
    }
}

