% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diags.R
\name{organize_summaries}
\alias{organize_summaries}
\title{Organize the summaries into a more palatable format}
\usage{
organize_summaries(hh_sum_list, p_sum_list, header_h, header_p, vars_to_sum_h,
  vars_to_sum_p, env_vars, samp_size, top_region_id, coords = TRUE,
  has_marg = FALSE)
}
\arguments{
\item{hh_sum_list}{output of summarize_spew for regions for households}

\item{p_sum_list}{output of summarize_spew for regions for people}

\item{header_h}{character vector of all variables in SPEW households}

\item{header_p}{character vector of all variables in SPEW people}

\item{vars_to_sum_h}{character vector of household variables we want to summarize}

\item{vars_to_sum_p}{character vector of people variables we want to summarize}

\item{env_vars}{variables to summarize}

\item{samp_size}{total number sampled in each region for plotting}

\item{top_region_id}{main region's ID or name}

\item{coords}{logical of whether to extract the longitude/latitude coordinates and store.  Default is TRUE}

\item{has_marg}{logical.  Does the synthetic ecosystem have marginals to look at?  Default is FALSE}
}
\value{
list including the top region name, headers for households and people, a coordinate plotting data frame scaled to the density of the population with max samp_size records, and data frames of tables for each region for each of the characteristics
}
\description{
Organize the summaries into a more palatable format
}
