% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{spfda}
\alias{spfda}
\title{Sparse Function-on-scalar Regression with Group Bridge Penalty}
\usage{
spfda(
  Y,
  X,
  lambda,
  time = seq(0, 1, length.out = ncol(Y)),
  nsp = "auto",
  ord = 4,
  alpha = 0.5,
  W = NULL,
  init = NULL,
  max_iter = 50,
  inner_iter = 50,
  CI = FALSE,
  ...
)
}
\arguments{
\item{Y}{Numeric \mjseqn{n \times T} matrix, response function.}

\item{X}{Numeric \mjseqn{n \times p} matrix, design matrix}

\item{lambda}{Regularization parameter \mjseqn{\gamma}}

\item{time}{Time domain, numerical length of \mjseqn{T}}

\item{nsp}{Integer or 'auto', number of B-splines \mjseqn{K};
default is 'auto'}

\item{ord}{B-spline order, default is \code{4}; must be \mjseqn{\geq 3}}

\item{alpha}{Bridge parameter \mjseqn{\alpha}, default is \code{0.5}}

\item{W}{A \mjseqn{T \times T} weight matrix or \code{NULL}
(identity matrix); default is \code{NULL}}

\item{init}{Initial \mjseqn{\gamma}; default is \code{NULL}}

\item{max_iter}{Number of outer iterations}

\item{inner_iter}{Number of \mjseqn{ADMM} iterations (inner steps)}

\item{CI}{Logical, whether to calculate theoretical confidence intervals}

\item{...}{Ignored}
}
\value{
A \code{spfda.model} object (environment) with following elements:
\describe{
\item{B}{B-spline basis functions used}
\item{error}{Root Mean Square Error ('RMSE')}
\item{CI}{Whether confidence intervals are calculated}
\item{gamma}{B-spline coefficient \mjseqn{\gamma_{p \times K}}}
\item{generate_splines}{Function to generate B-splines given time points}
\item{K}{Number of B-spline basis functions}
\item{knots}{B-spline knots used to fit the model}
\item{predict}{Function to predict responses \mjseqn{\beta(t)} given new
  \code{X} and/or time points}
\item{raw}{A list of raw variables}
}
}
\description{
\loadmathjax Function-on-scalar regression model, denote
\mjseqn{n} as total number of observations, \mjseqn{p} the number of
coefficients, \mjseqn{K} as the number of B-splines, \mjseqn{T} as total
time points.
}
\details{
This function implements "Functional Group Bridge for Simultaneous
Regression and Support Estimation" (\url{https://arxiv.org/abs/2006.10163}).
The model estimates functional coefficients \mjseqn{\beta(t)} under model
\mjsdeqn{y(t) = X\beta(t) + \epsilon(t)} with B-spline basis expansion
\mjsdeqn{\beta(t) = \gamma B(t) + R(t), } where \mjseqn{ R(t) } is B-spline
approximation error. The objective function
\mjsdeqn{
\left\| (Y-X\gamma B)W \right\|_{2}^{2} + \sum_{j,m}
\left\| \gamma_{j}^{T}\mathbf{1}(B^{t} > 0) \right\|_{1}^{\alpha}.
}
The input response variable is a matrix. If \mjseqn{y_{i}(t)} are observed
at different time points, please interpolate (e.g.
\code{\link[stats]{kernel}}) before feeding in.
}
\examples{

dat <- spfda_simulate()
x <- dat$X
y <- dat$Y

fit <- spfda(y, x, lambda = 5, CI = TRUE)

BIC(fit)

plot(fit, col = c("orange", "dodgerblue3", "darkgreen"),
     main = "Fitted with 95\% CI", aty = c(0, 0.5, 1), atx = c(0,0.2,0.8,1))
matpoints(fit$time, t(dat$env$beta), type = 'l', col = 'black', lty = 2)
legend('topleft', c("Fitted", "Underlying"), lty = c(1,2))

print(fit)
coefficients(fit)

}
