% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spftir.R
\name{spsgb}
\alias{spsgb}
\title{Savitzky-Golay Smoothing Filter of a Mid-infrared Spectra}
\usage{
spsgb(spectra, p = 2, sw = 21)
}
\arguments{
\item{spectra}{matrix. The matrix of FTIR spectra. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.}

\item{p}{numeric. Filter order. Defaults to 2.}

\item{sw}{numeric. Filter length (must be odd). Defaults to 21.}
}
\value{
A smoothed spectra matrix by means of a Savitzky-Golay smoothing filter. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.
}
\description{
This function allows applying a Savitzky-Golay smoothing filter to the mid-infrared spectra (N spectra > 1).
}
\examples{
data(spData)
# Convert data frame to matrix
spectra <- as.matrix(t(spData))
# Smoothed spectra
sgb <- spsgb(spectra=spectra, p=2, sw= 21)
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

