% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spidR.R
\name{map}
\alias{map}
\title{Map species ranges.}
\usage{
map(
  tax,
  countries = TRUE,
  records = TRUE,
  zoom = FALSE,
  window = FALSE,
  order = FALSE
)
}
\arguments{
\item{tax}{A taxon name or vector with taxa names.}

\item{countries}{Maps countries according to WSC.}

\item{records}{Maps records according to GBIF and WST.}

\item{zoom}{if records is TRUE, the map will be zoomed to the region with records.}

\item{window}{Indicates if the map should open in a new window.}

\item{order}{Order taxa names alphabetically or keep as in tax.}
}
\value{
A world map with countries and records highlighted.
}
\description{
Maps species range according to the World Spider Catalogue and records according to GBIF and the World Spider Trait database.
}
\details{
Countries based on the interpretation of the textual descriptions available at the World Spider Catalogue (2021). These might be only approximations to country level and should be taken with caution.
}
\examples{
\dontrun{
map(c("Pardosa hyperborea"))
map("Amphiledorus", zoom = TRUE)
map(c("Pardosa hyperborea", "Iberesia machadoi"), countries  = FALSE, zoom = TRUE, window = TRUE)
}
}
\references{
Pekar, S., Cernecka, L., Wolff, J., Mammola, S., Cardoso, P., Lowe, E., Fukushima, C.S., Birkhofer, K. & Herberstein, M.E. (2021). The spider trait database. Masaryk University, Brno, URL: https://spidertraits.sci.muni.cz

World Spider Catalog (2021). World Spider Catalog. Version 22.0. Natural History Museum Bern, online at http://wsc.nmbe.ch. doi: 10.24436/2.
}
