% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{manip_var_of}
\alias{manip_var_of}
\title{Suggest a manipulation variable.}
\usage{
manip_var_of(basis, rank = 1)
}
\arguments{
\item{basis}{Numeric matrix (p x d), orthogonal liner combinations of the
variables.}

\item{rank}{The number, specifying the variable with the \code{rank}-th largest
contribution. Defaults to 1.}
}
\value{
Numeric scalar, the column number of a variable.
}
\description{
Find the column number of the variable with the \code{rank}-ith largest
contribution of the \code{basis}.
Useful for identifying a variable to change the contribution of in a manual
tour, it's \code{manip_var} argument.
}
\examples{
dat <- scale_sd(wine[, 2:6])
bas <- basis_pca(dat)

manip_var_of(basis = bas) ## Variable with the largest contribution
manip_var_of(basis = bas, rank = 5) ## Variable with 5th-largest contribution
}
\seealso{
Other manual tour adjacent functions: 
\code{\link{create_manip_space}()},
\code{\link{interpolate_manual_tour}()},
\code{\link{manual_tour}()},
\code{\link{rotate_manip_space}()}
}
\concept{manual tour adjacent functions}
