% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_manual_tour.r
\name{rotate_manip_space}
\alias{rotate_manip_space}
\title{Performs a rotation on the manipulation space of the given manip var.}
\usage{
rotate_manip_space(manip_space, theta, phi)
}
\arguments{
\item{manip_space}{A (p, d+1) dim matrix (manipulation space) to be rotated.}

\item{theta}{Angle (radians) of "in-projection-plane" rotation (ie. on xy-
of the projection). Typically set by the manip_type argument in \code{proj_data()}.}

\item{phi}{Angle (radians) of "out-of-projection-plane" rotation (ie. into
the z-direction of the manipulation space. Effectively changes the norm
of the manip_var in the projection plane.}
}
\value{
A (p, d+1) orthonormal matrix of the rotated (manipulation) space.
The first 2 columns are x and y in the projection plane. The 3rd column
extends "in the z-direction" orthogonal to the projection plane.
}
\description{
A specific R3 rotation of the manipulation space for a 2D tour.
Typically called by \code{manual_tour()}. The first 2 columns are x and y in
the projection plane. The 3rd column extends "in the z-direction" orthogonal
to the projection plane.
}
\examples{
library(spinifex)
dat <- scale_sd(wine[, 2:6])
bas <- basis_pca(dat)
mv  <- manip_var_of(bas)
msp <- create_manip_space(basis = bas, manip_var = mv)
rotate_manip_space(msp, theta = runif(1, max = 2 * pi),
                   phi = runif(1, max = 2 * pi))

## d = 1 case
bas1d <- basis_pca(dat, d = 1)
mv    <- manip_var_of(bas1d)
msp   <- create_manip_space(bas1d, mv)
rotate_manip_space(msp, theta = 0, phi = runif(1, max = 2 * pi))
}
\seealso{
Other manual tour adjacent functions: 
\code{\link{create_manip_space}()},
\code{\link{interpolate_manual_tour}()},
\code{\link{manip_var_of}()},
\code{\link{manual_tour}()}
}
\concept{manual tour adjacent functions}
