% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main1.R, R/spinner.R
\docType{package}
\name{spinner}
\alias{spinner}
\alias{spinner-package}
\title{spinner}
\usage{
spinner(
  graph,
  target,
  node_labels = NA,
  edge_labels = NA,
  context_labels = NA,
  direction = "from_head",
  sampling = NA,
  threshold = 0.01,
  method = "null",
  node_embedding_size = 5,
  edge_embedding_size = 5,
  context_embedding_size = 5,
  update_order = "enc",
  n_layers = 3,
  skip_shortcut = FALSE,
  forward_layer = 32,
  forward_activation = "relu",
  forward_drop = 0.3,
  mode = "sum",
  optimization = "adam",
  epochs = 100,
  lr = 0.01,
  patience = 30,
  weight_decay = 0.001,
  reps = 1,
  folds = 3,
  holdout = 0.2,
  verbose = TRUE,
  seed = 42
)
}
\arguments{
\item{graph}{A graph in igraph format (without name index for nodes).}

\item{target}{String. Predicted dimension. Options are: "node", "edge".}

\item{node_labels}{String. Character vector with labels of node features. In case of absent features, default to NA (automatic node embedding with selected method).}

\item{edge_labels}{String. Character vector with labels of edge features. In case of absent features, default to NA (automatic edge embedding with selected method).}

\item{context_labels}{String. Character vector with labels of context features. In case of absent features, default to NA (automatic context embedding with selected method).}

\item{direction}{String. Direction of message propagation. Options are: "from_head", "from_tail". Default to: "from_head".}

\item{sampling}{Positive numeric or integer. In case of huge graph, you can opt for a subgraph. Sampling dimension expressed in absolute value or percentage. Default: NA (no sampling).}

\item{threshold}{Numeric. Below this threshold (calculated on edge density), sampling is done on edges, otherwise on nodes. Default: 0.01.}

\item{method}{String. Embedding method in case of absent features. Options are: "null" (zeroed tensor), "laplacian", "adjacency". Default: "null".}

\item{node_embedding_size}{Integer. Size for node embedding. Default: 5.}

\item{edge_embedding_size}{Integer. Size for edge embedding. Default: 5.}

\item{context_embedding_size}{Integer. Size for node embedding. Default: 5.}

\item{update_order}{String. The order of message passing through nodes (n), edges (e) and context (c) for updating information. Available options are: "enc", "nec", "cen", "ecn", "nce", "cne". Default: "enc".}

\item{n_layers}{Integer. Number of graph net variant layers. Default: 1.}

\item{skip_shortcut}{Logical. Flag for applying skip shortcut after the graph net variant layers. Default: FALSE.}

\item{forward_layer}{Integer. Single integer vector with size for forward net layer. Default: 32 (layers with 32 nodes).}

\item{forward_activation}{String. Single character vector with activation for forward net layer. Available options are: "linear", "relu", "mish", "leaky_relu", "celu", "elu", "gelu", "selu", "bent", "softmax", "softmin", "softsign", "sigmoid", "tanh". Default: "relu".}

\item{forward_drop}{Numeric. Single numeric vector with drop out for forward net layer. Default: 0.3.}

\item{mode}{String. Aggregation method for message passing. Options are: "sum", "mean", "max". Default: "sum".}

\item{optimization}{String. Optimization method. Options are: "adadelta", "adagrad", "rmsprop", "rprop", "sgd", "asgd", "adam".}

\item{epochs}{Positive integer. Default: 100.}

\item{lr}{Positive numeric. Learning rate. Default: 0.01.}

\item{patience}{Positive integer. Waiting time (in epochs) before evaluating the overfit performance. Default: 30.}

\item{weight_decay}{Positive numeric. L2-Regularization weight. Default: 0.001.}

\item{reps}{Positive integer. Number of repeated measures. Default: 1.}

\item{folds}{Positive integer. Number of folds for each repetition. Default: 3.}

\item{holdout}{Positive numeric. Percentage of nodes for testing (edges are computed accordingly). Default: 0.2.}

\item{verbose}{Logical. Default: TRUE}

\item{seed}{Random seed. Default: 42.}
}
\value{
This function returns a list including:
\itemize{
\item graph: analyzed graph is returned (original graph or sampled subgraph).
\item model_description: general model description.
\item model_summary: summary for each torch module.
\item pred_fun: function to predict on new graph data (you need to add new nodes/edges to the original graph respecting the directionality).
\item cv_error: cross-validation error for each repetition and each fold. The error is a weighted normalized loss based on mse and binary cross-entropy (depending on the nature of each specific feature).
\item summary_errors: final summary of error during cross-validation and testing.
\item history: plot with loss for final training and testing.
\item time_log: computation time.
}
}
\description{
Spinner is an implementation of Graph Nets based on torch. Graph Nets are a family of neural network architectures designed for processing graphs and other structured data. They consist of a set of message-passing operations, which propagate information between nodes and edges in the graph, and a set of update functions, which compute new node and edge features based on the received messages.

Proposes a 'torch' implementation of Graph Net architecture allowing different options for message passing and feature embedding.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/spinner}
}

}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}

\strong{Maintainer}: Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com} [copyright holder]

}
