% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfpred.R
\name{rfpred}
\alias{rfpred}
\title{Generate spatial predictions using random forest (RF)}
\usage{
rfpred(trainx, trainy, longlatpredx, predx, mtry = if (!is.null(trainy) &&
  !is.factor(trainy)) max(floor(ncol(trainx)/3), 1) else
  floor(sqrt(ncol(trainx))), ntree = 500, ...)
}
\arguments{
\item{trainx}{a dataframe or matrix contains columns of predictor variables.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in trainx.}

\item{longlatpredx}{a dataframe contains longitude and latitude of point
locations (i.e., the centres of grids) to be predicted.}

\item{predx}{a dataframe or matrix contains columns of predictive variables
for the grids to be predicted.}

\item{mtry}{a function of number of remaining predictor variables to use as
the mtry parameter in the randomForest call.}

\item{ntree}{number of trees to grow. This should not be set to too small a
number, to ensure that every input row gets predicted at least a few times.
By default, 500 is used.}

\item{...}{other arguments passed on to randomForest.}
}
\value{
A dataframe of longitude, latitude and predictions.
}
\description{
This function is to make spatial predictions using random forest.
}
\examples{
\dontrun{
data(petrel)
data(petrel.grid)
rfpred1 <- rfpred(petrel[, c(1,2, 6:9)], petrel[, 5], petrel.grid[, c(1,2)],
petrel.grid, ntree = 500)
names(rfpred1)
}

}
\references{
Liaw, A. and M. Wiener (2002). Classification and Regression by
randomForest. R News 2(3), 18-22.
}
\author{
Jin Li
}
