% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgidwcv.R
\name{rgidwcv}
\alias{rgidwcv}
\title{Cross validation, n-fold for the hybrid method of random forest in ranger
and inverse distance weighting (RGIDW)}
\usage{
rgidwcv(longlat, trainx, trainy, cv.fold = 10, mtry = function(p) max(1,
  floor(sqrt(p))), num.trees = 500, min.node.size = NULL,
  num.threads = NULL, verbose = FALSE, idp = 2, nmax = 12,
  predacc = "VEcv", ...)
}
\arguments{
\item{longlat}{a dataframe contains longitude and latitude of point
samples (i.e., trainx and trainy).}

\item{trainx}{a dataframe or matrix contains columns of predictive variables.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in trainx.}

\item{cv.fold}{integer; number of folds in the cross-validation. if > 1,
then apply n-fold cross validation; the default is 10, i.e., 10-fold cross
validation that is recommended.}

\item{mtry}{a function of number of remaining predictor variables to use as
the mtry parameter in the randomForest call.}

\item{num.trees}{number of trees. By default, 500 is used.}

\item{min.node.size}{Default 1 for classification, 5 for regression.}

\item{num.threads}{number of threads. Default is number of CPUs available.}

\item{verbose}{Show computation status and estimated runtime.Default is FALSE.}

\item{idp}{numeric; specify the inverse distance weighting power.}

\item{nmax}{for local predicting: the number of nearest observations that
should be used for a prediction or simulation, where nearest is
defined in terms of the space of the spatial locations. By default, 12
observations are used.}

\item{predacc}{can be either "VEcv" for vecv or "ALL" for all measures
in function pred.acc.}

\item{...}{other arguments passed on to randomForest or gstat.}
}
\value{
A list with the following components:
for numerical data: me, rme, mae, rmae, mse, rmse, rrmse, vecv and e1; or vecv.
}
\description{
This function is a cross validation function for the hybrid
method of random forest in ranger and inverse distance weighting (RGIDW).
}
\note{
This function is largely based on rfidwcv.
}
\examples{
\dontrun{
data(petrel)

rgidwcv1 <- rgidwcv(petrel[, c(1,2)], petrel[, c(1,2, 6:9)], petrel[, 5],
predacc = "ALL")
rgidwcv1

n <- 20 # number of iterations, 60 to 100 is recommended.
VEcv <- NULL
for (i in 1:n) {
rgidwcv1 <- rgidwcv(petrel[, c(1,2)], petrel[, c(1,2,6:9)], petrel[, 5],
predacc = "VEcv")
VEcv [i] <- rgidwcv1
}
plot(VEcv ~ c(1:n), xlab = "Iteration for RFIDW", ylab = "VEcv (\%)")
points(cumsum(VEcv) / c(1:n) ~ c(1:n), col = 2)
abline(h = mean(VEcv), col = 'blue', lwd = 2)

n <- 20 # number of iterations, 60 to 100 is recommended.
measures <- NULL
for (i in 1:n) {
rgidwcv1 <- rgidwcv(petrel[, c(1,2)], petrel[, c(1,2,6:9)], petrel[, 5],
predacc = "ALL")
measures <- rbind(measures, rgidwcv1$vecv)
}
plot(measures ~ c(1:n), xlab = "Iteration for RFIDW", ylab = "VEcv (\%)")
points(cumsum(measures) / c(1:n) ~ c(1:n), col = 2)
abline(h = mean(measures), col = 'blue', lwd = 2)
}

}
\references{
Li, J. 2013. Predicting the spatial distribution of seabed
gravel content using random forest, spatial interpolation methods and their
hybrid methods. Pages 394-400  The International Congress on Modelling and
Simulation (MODSIM) 2013, Adelaide.

Wright, M. N. & Ziegler, A. (2017). ranger: A Fast Implementation
of Random Forests for High Dimensional Data in C++ and R. J Stat Softw 77:1-17.
http://dx.doi.org/10.18637/jss.v077.i01.
}
\author{
Jin Li
}
