% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasplit.R
\name{datasplit}
\alias{datasplit}
\title{Split data for k-fold cross-validation}
\usage{
datasplit(trainy, k.fold = 10)
}
\arguments{
\item{trainy}{a vector of response, must have a length equal to sample size.}

\item{k.fold}{integer; number of folds in the cross-validation. if > 1,
then apply k-fold cross validation; the default is 10, i.e., 10-fold cross
validation that is recommended.}
}
\value{
A list of samples each with an index of k-fold number.
}
\description{
This function is a data splitting function for k-fold cross-
validation and uses a stratified random sampling technique. It resamples the
training data based on sample quantiles.
}
\note{
This function is largely based on rfcv in randomForest.
}
\examples{
library(spm)
data(petrel)
idx1 <- datasplit(petrel[, 3], k.fold = 10)
table(idx1)

}
\references{
A. Liaw and M. Wiener (2002). Classification and Regression
by randomForest. R News 2(3), 18-22.
}
\author{
Jin Li
}
