% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.spmodRF}
\alias{predict.spmodRF}
\alias{predict.spmodRF_list}
\title{Random forest spatial residual model predictions (random forest regression Kriging)}
\usage{
\method{predict}{spmodRF}(object, newdata, local, ...)

\method{predict}{spmodRF_list}(object, newdata, local, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splmRF]{splmRF()}} or \code{\link[=spautorRF]{spautorRF()}}.}

\item{newdata}{A data frame or \code{sf} object in which to
look for variables with which to predict. If a data frame, \code{newdata}
must contain all variables used by \code{formula(object)} and all variables
representing coordinates. If an \code{sf} object, \code{newdata} must contain
all variables used by \code{formula(object)} and coordinates are obtained
from the geometry of \code{newdata}. If omitted, missing data from the
fitted model object are used.}

\item{local}{A optional logical or list controlling the big data approximation
to the spatial residual prediction. If omitted, \code{local}
is set to \code{TRUE} or \code{FALSE} based on the sample size of the fitted
model object and/or the prediction size of \code{newdata} -- if the sample
size or prediction size exceeds 5000, \code{local} is
set to \code{TRUE}, otherwise it is set to \code{FALSE}. If \code{FALSE}, no big data approximation
is implemented. If a list is provided, the following arguments detail the big
data approximation:
\itemize{
\item{\code{method}: }{The big data approximation method. If \code{method = "all"},
all observations are used and \code{size} is ignored. If \code{method = "distance"},
the \code{size} data observations closest (in terms of Euclidean distance)
to the observation requiring prediction are used.
If \code{method = "covariance"}, the \code{size} data observations
with the highest covariance with the observation requiring prediction are used.
If random effects and partition factors are not used in estimation and
the spatial covariance function is monotone decreasing,
\code{"distance"} and \code{"covariance"} are equivalent. The default
is \code{"covariance"}. Only used with models fit using \code{\link[=splm]{splm()}}.}
\item{\code{size}: }{The number of data observations to use when \code{method}
is \code{"distance"} or \code{"covariance"}. The default is 50. Only used
with models fit using \code{\link[=splm]{splm()}}.}
\item{\code{parallel}: }{If \code{TRUE}, parallel processing via the
parallel package is automatically used. The default is \code{FALSE}.}
\item{\code{ncores}: }{If \code{parallel = TRUE}, the number of cores to
parallelize over. The default is the number of available cores on your machine.}
}
When \code{local} is a list, at least one list element must be provided to
initialize default arguments for the other list elements.
If \code{local} is \code{TRUE}, defaults for \code{local} are chosen such
that \code{local} is transformed into
\code{list(size = 50, method = "covariance", parallel = FALSE)}.}

\item{...}{Other arguments to \code{ranger::predict.ranger()}}
}
\value{
For \code{spmodRF} objects, a vector of predictions. For \code{spmodRF_list}
objects, a list that contains relevant quantities for each \code{spmodRF} object.
}
\description{
Predicted values based on a random forest spatial residual fitted model object.
}
\details{
For \code{spmodRF} objects, the random forest prediction is combined with
the (empirical) best linear unbiased prediction for the residual. Fox Et al.
call this approach random forest regression Kriging. For \code{spmodRF_list} objects,
predictions are returned for each \code{spmodRF} object.
}
\examples{
\donttest{
sulfate$var <- rnorm(NROW(sulfate)) # add noise variable
sulfate_preds$var <- rnorm(NROW(sulfate_preds)) # add noise variable
sprfmod <- splmRF(sulfate ~ var, data = sulfate, spcov_type = "exponential")
predict(sprfmod, sulfate_preds)
}
}
\references{
Fox, E.W., Ver Hoef, J. M., & Olsen, A. R. (2020). Comparing spatial
regression to random forests for large environmental data sets.
\emph{PloS one}, 15(3), e0229509.
}
