% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint.spmodel}
\alias{confint.spmodel}
\alias{confint.splm}
\alias{confint.spautor}
\title{Confidence intervals for fitted model parameters}
\usage{
\method{confint}{splm}(object, parm, level = 0.95, ...)

\method{confint}{spautor}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}.}

\item{parm}{A specification of which parameters are to be given confidence
intervals (a character vector of names). If missing, all parameters are considered.}

\item{level}{The confidence level required. The default is \code{0.95}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
Gaussian-based confidence intervals (two-sided and equal-tailed) for the
fixed effect coefficients based on the confidence level specified by \code{level}.
}
\description{
Computes confidence intervals for one or more parameters in a fitted
model object.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
confint(spmod)
confint(spmod, parm = "waterY", level = 0.90)
}
