% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rating_run.R
\name{bbt_run}
\alias{bbt_run}
\title{Bayesian Bradley-Terry}
\usage{
bbt_run(
  formula,
  data,
  r = numeric(0),
  rd = numeric(0),
  init_r = 25,
  init_rd = 25/3,
  lambda = NULL,
  share = NULL,
  weight = NULL,
  kappa = 0.5
)
}
\arguments{
\item{formula}{formula which specifies the model. RHS Allows only player 
rating parameter and it should be specified in following manner:

\code{rank | id ~ player(name)}.
\itemize{
  \item {rank} player position in event.
  \item {id} event identifier in which pairwise comparison is assessed.
  \item {player(name)} name of the contestant. In this case \code{player(name)} 
    helps algorithm point name of the column where player names are stored.
}
Users can also specify formula in in different way:
 \code{rank | id ~ player(name|team)}. Which means that players are playing in teams, 
 and results are observed for teams not for players. For more see vignette.}

\item{data}{data.frame which contains columns specified in formula, and
optional columns defined by \code{lambda}, \code{weight}.}

\item{r}{named vector of initial players ratings estimates. If not specified 
then \code{r} will be created automatically for parameters specified in \code{formula}
with initial value \code{init_r}.}

\item{rd}{rd named vector of initial rating deviation estimates. If not specified 
then \code{rd} will be created automatically for parameters specified in \code{formula}
with initial value \code{init_rd}.}

\item{init_r}{initial values for \code{r} if not provided. 
Default (\code{glicko = 1500}, \code{glicko2 = 1500}, \code{bbt = 25}, 
\code{dbl = 0})}

\item{init_rd}{initial values for \code{rd} if not provided. 
Default (\code{glicko = 350}, \code{glicko2 = 350}, \code{bbt = 25/3}, \code{dbl = 1})}

\item{lambda}{name of the column in `data` containing lambda values or one 
constant value (eg. \code{lambda = colname} or \code{lambda = 0.5}).
Lambda impact prior variance, and uncertainty of the matchup result. The 
higher lambda, the higher prior variance and more uncertain result of the 
matchup. Higher lambda flattens chances of winning.}

\item{share}{name of the column in `data` containing player share in team 
efforts. It's used to first calculate combined rating of the team and
then redistribute ratings update back to players level. Warning - it should
be used only if formula is specified with players nested within teams (`player(player|team)`).}

\item{weight}{name of the column in `data` containing weights values or
one constant (eg. \code{weight = colname} or \code{weight = 0.5}). 
Weights increasing (weight > 1) or decreasing (weight < 1) update change. 
Higher weight increasing impact of event result on rating estimate.}

\item{kappa}{controls \code{rd} shrinkage not to be greater than \code{rd*(1 - kappa)}.
`kappa=1` means that  \code{rd} will not be decreased.}
}
\value{
A "rating" object is returned: \itemize{

\item \code{final_r} named vector containing players ratings.

\item \code{final_rd} named vector containing players ratings deviations.

\item \code{r} data.frame with evolution of the ratings and ratings deviations
 estimated at each event.
 
\item \code{pairs} pairwise combinations of players in analysed events with 
prior probability and result of a challenge.

\item \code{class} of the object.

\item \code{method} type of algorithm used.

\item \code{settings} arguments specified in function call.
}
}
\description{
Bayesian Bradley-Terry
}
\examples{
# the simplest example
data <- data.frame(
  id = c(1, 1, 1, 1),
  team = c("A", "A", "B", "B"),
  player = c("a", "b", "c", "d"),
  rank_team = c(1, 1, 2, 2),
  rank_player = c(3, 4, 1, 2)
)

bbt <- bbt_run(
  data = data, 
  formula = rank_player | id ~ player(player),
   r = setNames(c(25, 23.3, 25.83, 28.33), c("a", "b", "c", "d")),
   rd = setNames(c(4.76, 0.71, 2.38, 7.14), c("a", "b", "c", "d"))
  )
  
# nested matchup
bbt <- bbt_run(
  data = data, 
  formula = rank_team | id ~ player(player | team)
 )

}
