% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/playlists.R
\name{change_playlist_details}
\alias{change_playlist_details}
\title{Change a playlist’s name and public/private state. (The user must, of course, own the playlist.)}
\usage{
change_playlist_details(playlist_id, name = NULL, public = NULL,
  collaborative = NULL, description = NULL,
  authorization = get_spotify_authorization_code())
}
\arguments{
\item{playlist_id}{Required. The \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify ID} for the playlist.}

\item{name}{Optional String containing the name for the new playlist, for example \code{"Your Coolest Playlist"}. This name does not need to be unique; a user may have several playlists with the same name.}

\item{public}{Optional. Boolean. If \code{TRUE} the playlist will be public. If \code{FALSE} it will be private.}

\item{collaborative}{Optional. Boolean. If \code{TRUE} the playlist will become collaborative and other users will be able to modify the playlist in their Spotify client.Note: you can only set \code{collaborative} to \code{TRUE} on non-public playlists.}

\item{description}{Optional. String containing the playlist description as displayed in Spotify Clients and in the Web API.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization Guide} for more details. Defaults to \code{spotifyr::get_spotify_authorization_code()}. The access token must have been issued on behalf of the current user. \cr
Changing a public playlist for a user requires authorization of the \code{playlist-modify-public} scope; changing a private playlist requires the \code{playlist-modify-private} scope. See \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/#list-of-scopes}{Using Scopes}.}
}
\description{
Change a playlist’s name and public/private state. (The user must, of course, own the playlist.)
}
