% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotspot_cluster.R
\name{hotspot_cluster}
\alias{hotspot_cluster}
\title{Spatiotemporal clustering of hot spot data}
\usage{
hotspot_cluster(
  hotspots,
  lon = "lon",
  lat = "lat",
  obsTime = "obsTime",
  activeTime = 24,
  adjDist = 3000,
  minPts = 4,
  minTime = 3,
  ignitionCenter = "mean",
  timeUnit = "n",
  timeStep = 1
)
}
\arguments{
\item{hotspots}{List/Data frame. A list or a data frame which
contains information of hot spots.}

\item{lon}{Character. The name of the column of the list which contains
numeric longitude values.}

\item{lat}{Character. The name of the column of the list which contains
numeric latitude values.}

\item{obsTime}{Character. The name of the column of the list which contains
the observed time of hot spots. The observed time
has to be in date, datetime or numeric.}

\item{activeTime}{Numeric (>=0). Time tolerance. Unit is time index.}

\item{adjDist}{Numeric (>0). Distance tolerance. Unit is metre.}

\item{minPts}{Numeric (>0). Minimum number of hot spots in a cluster.}

\item{minTime}{Numeric (>=0). Minimum length of time of a cluster.
Unit is time index.}

\item{ignitionCenter}{Character. Method to calculate ignition points,
either "mean" or "median".}

\item{timeUnit}{Character. One of "s" (seconds),
"m" (minutes), "h" (hours),
"d" (days) and "n" (numeric).}

\item{timeStep}{Numeric (>0). Number of units of \code{timeUnit} in a time step.}
}
\value{
A \code{spotoroo} object. The clustering results. It is also a list:
\itemize{
\item \code{hotspots} : A data frame contains information of hot spots.
\itemize{
\item \code{lon} : Longitude.
\item \code{lat} : Latitude.
\item \code{obsTime} : Observed time.
\item \code{timeID} : Time index.
\item \code{membership} : Membership label.
\item \code{noise} : Whether it is a noise point.
\item \code{distToIgnition} : Distance to the ignition location.
\item \code{distToIgnitionUnit} : Unit of distance to the ignition
location.
\item \code{timeFromIgnition} : Time from ignition.
\item \code{timeFromIgnitionUnit} : Unit of time from ignition.
}
\item \code{ignition} : A data frame contains information of ignition
points.
\itemize{
\item \code{lon} : Longitude.
\item \code{lat} : Latitude.
\item \code{obsTime} : Observed time.
\item \code{timeID} : Time index.
\item \code{obsInCluster} : Number of observations in the cluster.
\item \code{clusterTimeLen} : Length of time of the cluster.
\item \code{clusterTimeLenUnit} : Unit of length of time of the
cluster.
}
\item \code{setting} : A list contains the clustering settings.
}
}
\description{
This is the main function of the package.
\cr
This function clusters hot spots into fires. It can be used to
reconstruct fire history and detect fire ignition points.
}
\details{
Arguments \code{timeUnit} and \code{timeStep} need to be
specified to convert date/datetime/numeric to time index.
More details can be found in \code{\link[=transform_time_id]{transform_time_id()}}.
\cr\cr
This clustering algorithm consisted of \strong{5 steps}:
\cr\cr
In \strong{step 1}, it defines \eqn{T} intervals using the time index
\deqn{Interval(t) = [max(1, t - activeTime),t]}
where \eqn{t = 1, 2, ..., T}, and \eqn{T} is the maximum time index.
\code{activeTime} is an argument that needs to be specified. It represents
the maximum time difference between two hot spots in the same local
cluster. Please notice that a local cluster is different with a cluster
in the final result. More details will be given in the next part.
\cr\cr
In \strong{step 2}, the algorithm performs spatial clustering on each interval.
A local cluster is a cluster found in an interval. Argument \code{adjDist}
is used to control the spatial clustering. If the distance between two
hot spots is smaller or equal to \code{adjDist}, they are directly-connected. If
hot spot \code{A} is directly-connected with hot spot \code{B} and hot spot \code{B} is
directly-connected with hot spot \code{C}, hot spot \code{A}, \code{B} and \code{C} are
connected. All connected hot spots become a local cluster.
\cr\cr
In \strong{step 3}, the algorithm starts from interval \eqn{1}. It marks all
hot spots in this interval and records their membership labels.
Then it moves on to interval \eqn{2}. Due to a hot spot could exist in
multiple intervals, it checks whether any hot spot in interval \eqn{2}
has been marked. If there is any, their membership labels will be
carried over from the record. Unmarked hot spots in interval \eqn{2},
which share the same local cluster with marked hot spots, their
membership labels are carried over from marked hot spots. If a unmarked
hot spot shares the same local cluster with multiple marked hot spots, the
algorithm will carry over the membership label from the nearest one. All
other unmarked hot spots in interval \eqn{2} that do not share the same
cluster with any marked hot spot, their membership labels will be adjusted
such that the clusters they belong to are considered to be new clusters.
Finally, all
hot spots in interval \eqn{2} are marked and their membership labels are
recorded. This process continues for interval \eqn{3}, \eqn{4}, ...,
\eqn{T}. After finishing step 3, all hot spots are marked and their
membership labels are recorded.
\cr\cr
In \strong{step 4}, it checks each cluster. If there is any cluster contains less
than \code{minPts} hot spots, or lasts shorter than \code{minTime}, it will not be
considered to be a cluster any more, and their hot spots will be
assigned with \code{-1} as their membership labels. A hot spot with membership
label \code{-1} is noise.
Arguments \code{minPts} and \code{minTime} need to be specified.
\cr\cr
In \strong{step 5}, the algorithm finds the earliest observed hot spots in each
cluster and records them as ignition points. If there are multiple
earliest observed hot spots in a cluster, the mean or median of the
longitude values and the latitude values will be used as the coordinate
of the ignition point. This needs to be specified in argument
\code{ignitionCenter}.
}
\examples{
\donttest{

  # Time consuming functions (>5 seconds)


  # Get clustering results
  result <- hotspot_cluster(hotspots,
                lon = "lon",
                lat = "lat",
                obsTime = "obsTime",
                activeTime = 24,
                adjDist = 3000,
                minPts = 4,
                minTime = 3,
                ignitionCenter = "mean",
                timeUnit = "h",
                timeStep = 1)

  # Make a summary of the clustering results
  summary(result)

  # Make a plot of the clustering results
  plot(result, bg = plot_vic_map())
}

}
