% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kstest2d.R
\name{kstest2dsurf}
\alias{kstest2dsurf}
\title{Nonparametric Goodness-of-fit test for a point pattern against a surface}
\usage{
kstest2dsurf(pp, intsurf, truncate = FALSE, iters = 500)
}
\arguments{
\item{pp}{Object of class \code{\link[spatstat]{ppp}}.}

\item{intsurf}{Object of class \code{intensity_surface}.}

\item{truncate}{Requests to truncate the generated point patterns
to be within the window of the intensity object intsurf. Default is FALSE.}

\item{iters}{Number of point patterns to generate and
compare against \code{pp}. The larger this
value is, the more test performed, and thus the
more reliable the result.}
}
\description{
This function performs a two-dimensional Kolmogorov-Smirnov goodness-of-fit
test for a point pattern against a given intensity surface.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#kstest2dsurf}
}
\examples{

\dontrun{
# generate two intensity surfaces; assume the same window [-3,3]x[-3,3]
mixsurf1 <- rmixsurf(m = 3, lambda=100,xlim=c(-3,3),ylim=c(-3,3))
plot(mixsurf1)
mixsurf2 <- rmixsurf(m = 5, lambda=200,xlim=c(-3,3),ylim=c(-3,3))
plot(mixsurf2)
#generate point patterns from the two different models
pp1 <- rsppmix(mixsurf1, truncate=FALSE)
plotmix_2d(mixsurf1,pp1,colors=TRUE)
pp2 <- rsppmix(mixsurf2, truncate=FALSE)
plotmix_2d(mixsurf2,pp2,colors=TRUE)
# Test for goodness of fit, p-value should be small
kstest2d(pp1, pp2)
# Test each pattern for gof against both Poisson models
kstest2dsurf(pp1, mixsurf1)#correct model for pp1
kstest2dsurf(pp1, mixsurf2)#wrong model for pp1
kstest2dsurf(pp2, mixsurf2)#correct model for pp2
kstest2dsurf(pp2, mixsurf1)#wrong model for pp2}

}
\author{
Sakis Micheas
}
\seealso{
\code{\link{rmixsurf}},
\code{\link{kstest2d}},
\code{\link{rsppmix}},
\code{\link{plotmix_2d}}
}

