% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot.discovery.curve.R
\name{plot.discovery.curve}
\alias{plot.discovery.curve}
\title{Plot a Discovery Curve}
\usage{
\method{plot}{discovery.curve}(x, col = "darksalmon", lwd = 2,
  xlab = "# Samples", ylab = "n", add = FALSE, ...)
}
\arguments{
\item{x}{result of a call to \code{discovery.curve}.}

\item{col}{color of confidence interval polygon and line denoting
\code{s.est}.}

\item{lwd}{line widths.}

\item{xlab,ylab}{labels of x and y axes. Only used if \code{add} is
\code{TRUE}.}

\item{add}{logical. If TRUE, polygon and lines are added to the current plot.}

\item{...}{other arguments passed to plot (ignored).}
}
\description{
Plot a species discovery curve.
}
\examples{
data(osa.old.growth)
f <- expand.freqs(osa.old.growth)
d <- discovery.curve(f, f0.func = Chao1, max.x = 1200)
plot(d)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\references{
Colwell, R.K., A. Chao, N.J. Gotelli, S.-Y. Lin, C.X. Mao,
  R.L. Chazdon, and J.T. Longino. 2012. Models and estimators linking
  individual-based and sample-based rarefaction, extrapolation and
  comparison of assemblages. Journal of Plant Ecology 5(1):3-21.
}
\seealso{
\code{\link{discovery.curve}}
}

