% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity.R
\name{diversity}
\alias{diversity}
\title{Diversity Indices}
\usage{
diversity(
  x,
  type = c("effective.number", "richness", "shannon", "simpson", "gini.simpson",
    "unb.gini", "eveness.simpson", "eveness.pielou", "inv.simpson", "renyi", "hill"),
  q = NULL
)
}
\arguments{
\item{x}{vector or matrix of values (character, factor) representing a 
class, from which proportions will be computed. If numeric, 
values will be converted to proportions. If a matrix, indices
will be computed for all columns.}

\item{type}{type of index to compute. See Details for descriptions.
If \code{"renyi"} or \code{"hill"}, then \code{"q"} must be specified.}

\item{q}{order of Hill number (must be >= 0).}
}
\value{
if a vector is supplied for \code{x}, a single value for the chosen 
  type of index. If a matrix, a vector values for each column.
}
\description{
Calculate common diversity and entropy indices.
}
\note{
Available indices for \code{type} are: \describe{
  \item{richness}{the number of observed classes (non-\code{NA} and frequency > 0)}
  \item{effective.number}{exponent of Hill number of order 1}
  \item{shannon}{Shannon entropy}
  \item{simpson}{Simpson concentration}
  \item{gini.simpson}{Gini-Simpson index (= 1 - Simpson concentration)}
  \item{inv.simpson}{Inverse Simpson concentration}
  \item{unb.gini}{unbiased Gini-Simpson index with correction for small sample sizes}
  \item{eveness.simpson}{Simpson eveness}
  \item{eveness.pielou}{Pielou eveness}
  \item{renyi}{Renyi entropy}
  \item{hill}{Hill number}
}
}
\examples{
x <- sample(letters[1:4], 100, replace = TRUE, p = c(1, 2, 3, 4))

types <- c("richness", "effective.number", "shannon",
  "simpson", "inv.simpson", "gini.simpson", "unb.gini",
  "eveness.simpson", "eveness.pielou"
)

sapply(types, function(tp) diversity(x, type = tp))

# hill numbers with increasing order
order <- 0:5
hill.num <- sapply(order, function(q) diversity(x, type = "hill", q = q))
hill.num
plot(order, hill.num, type = "b")

# a matrix of frequencies
spp.freq <- cbind(
  sample(letters[1:4], 100, replace = TRUE, p = c(1, 1, 1, 4)),
  sample(letters[1:4], 100, replace = TRUE, p = c(4, 1, 1, 1)),
  sample(letters[1:4], 100, replace = TRUE, p = c(1, 1, 1, 1))
)

diversity(spp.freq, type = "eff")

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
