% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUIcollections.R
\name{spsCodeBtn}
\alias{spsCodeBtn}
\title{Display your code in a bootstrap modal or collapse}
\usage{
spsCodeBtn(
  id,
  code,
  language = "r",
  label = "",
  title = "Code to Reproduce",
  show_span = FALSE,
  tool_tip = "Show Code",
  placement = "bottom",
  btn_icon = icon("code"),
  display = c("modal", "collapse"),
  size = c("large", "medium", "small"),
  color = "black",
  shape = c("rect", "circular"),
  ...
)
}
\arguments{
\item{id}{element ID}

\item{code}{code you want to display, in a character string or vector.}

\item{language}{string, what programming language is the code, use \code{\link[shinyAce:getAceModes]{shinyAce::getAceModes()}}
to see options}

\item{label}{string, label to display on the button}

\item{title}{string, title of the modal or collapse}

\item{show_span}{bool, use the \verb{<span>} tag to show a little label of the
left of the button? The span text will use text from \code{tool_tip}}

\item{tool_tip}{string, what tooltip to display when hover on the button}

\item{placement}{string, where to display the tooltip}

\item{btn_icon}{icon, \code{\link[shiny:icon]{shiny::icon()}}, icon of the button}

\item{display}{string, one of "modal", "collapse"}

\item{size}{string, one of "large", "medium", "small", only works for modal}

\item{color}{string, color of the button}

\item{shape}{string, shape of the button, one of "rect", "circular",}

\item{...}{other args pass to the \link[shiny:actionButton]{shiny::actionButton}}
}
\value{
a shiny element
}
\description{
Developers often wants to show their code in a shiny app.
This function creates a button that when clicked, a modal or collapse
hidden element will show up to display your code.
}
\details{
\enumerate{
\item The modal or collapse has an ID, the ID is your button ID + "-modal" or "-collapse",
like "my_button-modal"
\item You could update the code inside the collapse use \link[shinyAce:updateAceEditor]{shinyAce::updateAceEditor}
on server, the code block ID is button ID + "-ace", like "my_button-ace" . See
examples.
}
}
\examples{
if(interactive()){
  library(shiny)
  my_code <-
    '
    # load package and data
    library(ggplot2)
    data(mpg, package="ggplot2")
    # mpg <- read.csv("http://goo.gl/uEeRGu")

    # Scatterplot
    theme_set(theme_bw())  # pre-set the bw theme.
    g <- ggplot(mpg, aes(cty, hwy))
    g + geom_jitter(width = .5, size=1) +
      labs(subtitle="mpg: city vs highway mileage",
           y="hwy",
           x="cty",
           title="Jittered Points")
    '
  html_code <-
    '
    <!DOCTYPE html>
    <html>
    <body>

    <h2>ABC</h2>

    <p id="demo">Some HTML</p>

    </body>
    </html>
    '
  ui <- fluidPage(
    fluidRow(
      column(
        6,
        h3("Display by modal"),
        column(
          6, h4("default"),
          spsCodeBtn(id = "a", my_code)
        ),
        column(
          6, h4("change color and shape"),
          spsCodeBtn(
            id = "b", c(my_code, my_code),
            color = "red", shape = "circular")
        )
      ),
      column(
        6,
        h3("Display by collapse"),
        column(
          6, h4("collapse"),
          spsCodeBtn(id = "c", my_code, display = "collapse")
        ),
        column(
          6, h4("different programming language"),
          spsCodeBtn(
            id = "d", html_code,
            language = "html", display = "collapse")
        )
      )
    ),
    fluidRow(
      column(
        6,
        h3("Update code"),
        spsCodeBtn(
          "update-code",
          "# No code here",
          display = "collapse"
        ),
        actionButton("update", "change code in the left `spsCodeBtn`"),
        actionButton("changeback", "change it back")
      )
    )
  )

  server <- function(input, output, session) {
    observeEvent(input$update, {
      shinyAce::updateAceEditor(
        session, editorId = "update-code-ace",
        value = "# code has changed!\n 1+1"
      )
    })
    observeEvent(input$changeback, {
      shinyAce::updateAceEditor(
        session, editorId = "update-code-ace",
        value = "# No code here"
      )
    })
  }

  shinyApp(ui, server)
}
}
