% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs_components.R
\name{spsTitle}
\alias{spsTitle}
\alias{tabTitle}
\title{Colorful title element}
\usage{
spsTitle(
  title,
  level = "2",
  status = "info",
  other_color = NULL,
  opacity = 1,
  ...
)

tabTitle(
  title,
  level = "2",
  status = "info",
  other_color = NULL,
  opacity = 1,
  ...
)
}
\arguments{
\item{title}{string, title text}

\item{level}{string, level of the title, the larger, the bigger, one of
"1", "2", "3", "4", "5", "6"}

\item{status}{string, one of "primary", "info", "success", "warning", "danger".
This determines the color of the line.}

\item{other_color}{string, if you do not like the default 5 status colors,
specify a valid CSS color here. If this is provided, \code{status} will be ignored.}

\item{opacity}{numeric, a number larger than 0 smaller than 1}

\item{...}{other attributes and children add to this element}
}
\value{
returns a shiny tag
}
\description{
Add a title element to UI
}
\examples{
if(interactive()) {
  library(shiny)
  library(magrittr)
  ui <- fluidPage(
    tags$b("Different status"),
    c("primary", "info", "success", "warning", "danger") \%>\%
      lapply(function(x) spsTitle(x, "4", status = x)),
    tags$b("custom color"),
    spsTitle("purple", "4", other_color = "purple"),
    spsTitle("pink", "4", other_color = "pink"),
    tags$b("Different levels"),
    lapply(as.character(1:6), function(x) spsTitle(paste0("H", x), x)),
    tags$b("Different opacity"),
    lapply(seq(0.2, 1, 0.2), function(x) spsTitle(as.character(x), opacity = x))
  )
  server <- function(input, output, session) {}
  shinyApp(ui, server)
}
}
