% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUtil.R
\name{notFalsy}
\alias{notFalsy}
\alias{isFalsy}
\alias{emptyIsFalse}
\title{Judgement of falsy value}
\usage{
notFalsy(x)

isFalsy(x)

emptyIsFalse(x)
}
\arguments{
\item{x}{any R object}
}
\value{
\code{NA}, \code{""}, \code{NULL}, \code{length(0)}, \code{nchar == 0} and \code{FALSE} will return
\code{FALSE}, otherwise \code{TRUE} in \code{notFalsy} and the opposite in \code{isFalsy}
}
\description{
judge if an object is or not a falsy value. This includes:
empty value, empty string \code{""}, \code{NULL}, \code{NA}, length of 0 and \code{FALSE} itself
}
\details{
R does not have good built-in methods to judge falsy values and these kind
of values often cause errors in \code{if} conditions, for example
\code{if(NULL) 1 else 2} will cause error. So this function will be useful to
handle this kind of situations: \code{if(notFalsy(NULL)) 1 else 2}.
\enumerate{
\item not working on S4 class objects.
\item \code{isFalsy} is the reverse of \code{notFalsy}: \code{isFalsy(x)} = !\code{notFalsy(x)}
\item \code{emptyIsFalse} is the old name for \code{notFalsy}
}

Useful for if statement. Normal empty object in if will spawn error. Wrap the
expression with \code{emptyIsFalse} can avoid this. See examples
}
\examples{
notFalsy(NULL)
notFalsy(NA)
notFalsy("")
try(`if(NULL) "not empty" else "empty"`) # this will generate error
if(notFalsy(NULL)) "not falsy" else "falsy" # but this will work
# Similar for `NA`, `""`, `character(0)` and more
isFalsy(NULL)
isFalsy(NA)
isFalsy("")
}
