% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shypFun.01310.R
\name{shypFun.01310}
\alias{shypFun.01310}
\title{van Genuchten-Mualem trimodal Soil Hydraulic Propterty Model}
\usage{
shypFun.01310(p, h)
}
\arguments{
\item{p}{vector of the 9 van Genuchten-Mualem model parameters, order is sensitve and has to be given as:
\tabular{lll}{
      \code{thr}\tab{residual water water content [cm cm-3]}\cr
      \code{ths}\tab{saturated water water content [cm cm-3]}\cr
      \code{alf1}\tab{van Genuchten alpha [cm-3]}\cr
      \code{n1}\tab{van Genuchten n [-]}\cr
      \code{w1}\tab{fraction of the first modality [-], \code{w2} is internally computed as \code{w2 = 1-w1}}\cr
      \code{alf2}\tab{van Genuchten alpha of the second modality[cm-3]}\cr
      \code{n2}\tab{van Genuchten n of the second modality [-]}\cr
      \code{w2}\tab{fraction of the second modality [-], \code{w3} is internally computed as \code{w3 = 1-w1-w2}, in \code{resFun} ensures \code{w3 >=0} }\cr
      \code{alf3}\tab{van Genuchten alpha of the third modality[cm-3]}\cr
      \code{n3}\tab{van Genuchten n of the third modality [-]}\cr
      \code{Ks}\tab{saturated conductivity [cm d-1]}\cr
      \code{tau}\tab{exponent of \code{Se} in the capillary conductivity model, sometimes denoted in the literature as \code{l} [-]}
}}

\item{h}{pressure heads [cm] for which the corresponding retention and conductivity values are calculated.}
}
\value{
returns a \code{list} with calculations at specified \code{h}:
\item{theta}{calculated volumetric moisture content}
\item{Se}{calculated saturation}
\item{cap}{specific water capacity function}
\item{psd}{pore size distribution}
\item{Kh}{Hydraulic conductivity values}
}
\description{
trimodal van Genuchten-Mualem functions for the retention and hydraulic conductivity curves \insertCite{Durner.1994}{spsh}.
}
\details{
The function solves analytically the spec. water capacity function and integral to the capillary bundle model.
}
\examples{
p <- c("thr" = 0.1, "ths" = 0.4, alf1 = .5, "n1" = 3,
       "w1" = .5, "alf2" = 0.01, "n2" = 2, 
       "w2" = .3, "alf3" = 0.01, "n3" = 1.6, 
       "Ks" = 100, "tau" = .5)
h <- 10^seq(-2, 6.8, length = 197)
shyp.L <- shypFun.01310(p, h)

}
\references{
\insertRef{Durner.1994}{spsh}\cr
}
\seealso{
\insertRef{Weber.2019}{spsh}\cr
\insertRef{Weber.2017a}{spsh}\cr
\insertRef{Weber.2017b}{spsh}\cr
}
\author{
Tobias KD Weber , \email{tobias.weber@uni-hohenheim.de}
}
