\name{change.est}
\alias{change.est}
\title{Category Proportion and Size Estimates}
\description{
  This function estimates change between two probability surveys.  Upper and lower confidence
  bounds also are estimated.
}
\usage{
change.est(resp.ind, z_1, wgt_1, x_1=NULL, y_1=NULL, repeat_1, z_2,
   wgt_2, x_2=NULL, y_2=NULL, repeat_2, revisitwgt=FALSE, stratum_1=NULL,
   stratum_2=NULL, cluster_1=NULL, cluster_2=NULL, wgt1_1=NULL, x1_1=NULL,
   y1_1=NULL, wgt1_2=NULL, x1_2=NULL, y1_2=NULL, popsize_1=NULL, popsize_2=NULL,
   popcorrect_1=FALSE, pcfsize_1=NULL, N.cluster_1=NULL, stage1size_1=NULL,
   support_1=NULL, popcorrect_2=FALSE, pcfsize_2=NULL, N.cluster_2=NULL,
   stage1size_2=NULL, support_2=NULL, sizeweight_1=FALSE, swgt_1=NULL,
   swgt1_1=NULL, sizeweight_2=FALSE, swgt_2=NULL, swgt1_2=NULL,
   vartype_1="Local", vartype_2="Local", conf=95, check.ind=TRUE, warn.ind=NULL,
   warn.df=NULL, warn.vec=NULL)
}
\arguments{
  \item{resp.ind}{a character value that indicates the type of response
    variable, where "cat" indicates a categorical variable and "cont" indicates
    a continuous variable.}
  \item{z_1}{response value for each survey one site.}
  \item{wgt_1}{the final adjusted weight (inverse of the sample inclusion
    probability) for each survey one site, which is either the weight for a 
    single-stage sample or the stage two weight for a two-stage sample.}
  \item{x_1}{x-coordinate for location for each survey one site, which is either
    the x-coordinate for a single-stage sample or the stage two x-coordinate for
    a two-stage sample.  The default is NULL.}
  \item{y_1}{y-coordinate for location for each survey one site, which is either
    the y-coordinate for a single-stage sample or the stage two y-coordinate for
    a two-stage sample.  The default is NULL.}
  \item{repeat_1}{a logical variable that identifies repeat visit sites for
    survey one.}
  \item{z_2}{response value for each survey two site.}
  \item{wgt_2}{the final adjusted weight for each survey two site.}
  \item{x_2}{x-coordinate for location for each survey two site.  The default is
    NULL.}
  \item{y_2}{y-coordinate for location for each survey two site.  The default is
    NULL.}
  \item{repeat_2}{a logical variable that identifies repeat visit sites for
    survey two.}
  \item{revisitwgt}{a logical value that indicates whether the repeat visit
    sites in the two surveys have the same survey design weights, where TRUE =
    the weights are the same and FALSE = the weights are not the same.  When
    this argument is FALSE, the repeat visit sites are assigned equal weights
    when calculating the covariance component of the change estimate varaince.
    The default is FALSE.}
  \item{stratum_1}{the stratum for each survey one site.  The default is NULL.}
  \item{stratum_2}{the stratum for each survey two site.  The default is NULL.}
  \item{cluster_1}{the stage one sampling unit (primary sampling unit or
    cluster) code for each survey one site.  The default is NULL.}
  \item{cluster_2}{the stage one sampling unit (primary sampling unit or
    cluster) code for each survey two site.  The default is NULL.}
  \item{wgt1_1}{the final adjusted stage one weight for each survey one site.
    The default is NULL.}
  \item{x1_1}{the stage one x-coordinate for location for each survey one site.
    The default is NULL.}
  \item{y1_1}{the stage one y-coordinate for location for each survey one site.
    The default is NULL.}
  \item{wgt1_2}{the final adjusted stage one weight for each survey two site.
    The default is NULL.}
  \item{x1_2}{the stage one x-coordinate for location for each survey two site.
    The default is NULL.}
  \item{y1_2}{the stage one y-coordinate for location for each survey two site.
    The default is NULL.}
  \item{popsize_1}{known size of the survey one resource, which is used to
    perform ratio adjustment to estimators expressed using measurement units for
    the resource.  For a finite resource, this argument is either the total
    number of sampling units or the known sum of size-weights.  For an extensive
    resource, this argument is the measure of the resource, i.e., either known
    total length for a linear resource or known total area for an areal
    resource.  For a stratified sample this variable must be a vector
    containing a value for each stratum and must have the names attribute set
    to identify the stratum codes.  The default is NULL.}
  \item{popsize_2}{known size of the survey two resource.  The default is NULL.}
  \item{popcorrect_1}{a logical value that indicates whether finite or
    continuous population correction factors should be employed during variance 
    estimation for survey one, where TRUE = use the correction factors and FALSE
    = do not use the correction factors.  The default is FALSE.}
  \item{pcfsize_1}{size of the survey one resource, which is required for
    calculation of finite and continuous population correction factors for a
    single-stage sample.  For a stratified sample this argument must be a vector
    containing a value for each stratum and must have the names attribute set to
    identify the stratum codes.  The default is NULLL.}
  \item{N.cluster_1}{the number of stage one sampling units in the survey one
    resource, which is required for calculation of finite and continuous
    population correction factors for a two-stage sample.  For a stratified
    sample this variable must be a vector containing a value for each stratum
    and must have the names attribute set to identify the stratum codes.  The
    default is NULL.}
  \item{stage1size_1}{size of the stage one sampling units of a two-stage sample
    for survey one, which is required for calculation of finite and continuous
    population correction factors for a two-stage sample and must have the names
    attribute set to identify the stage one sampling unit codes.  For a
    stratified sample, the names attribute must be set to identify both
    stratum codes and stage one sampling unit codes using a convention where
    the two codes are separated by the & symbol, e.g., "Stratum 1&Cluster 1".
    The default is NULL.}
  \item{support_1}{the support value for each survey one site - the value one
    (1) for a site from a finite resource or the measure of the sampling unit
    associated with a site from an extensive resource, which is required for
    calculation of finite and continuous population correction factors.  The
    default is NULL.}
  \item{popcorrect_2}{a logical value that indicates whether finite or
    continuous population correction factors should be employed during variance 
    estimation for survey two.  The default is FALSE.}
  \item{pcfsize_2}{size of the survey two resource.  The default is NULLL.}
  \item{N.cluster_2}{the number of stage one sampling units in the survey two
    resource.  The default is NULL.}
  \item{stage1size_2}{size of the stage one sampling units of a two-stage sample
    for survey two.   The default is NULL.}
  \item{support_2}{the support value for each survey two site.  The default is
    NULL.}
  \item{sizeweight_1}{a logical value that indicates whether size-weights should 
    be used in the analysis for survey one, where TRUE = use the size-weights
    and FALSE =  do not use the size-weights.  The default is FALSE.}
  \item{swgt_1}{the size-weight for each survey one site, which is the stage two
    size-weight for a two-stage sample.  The default is NULL.}
  \item{swgt1_1}{the stage one size-weight for each survey one site.  The
    default is NULL.}
  \item{sizeweight_2}{a logical value that indicates whether size-weights should 
    be used in the analysis for survey two.  The default is FALSE.}
  \item{swgt_2}{the size-weight for each survey two site.  The default is NULL.}
  \item{swgt1_2}{the stage one size-weight for each survey two site.  The
    default is NULL.}
  \item{vartype_1}{the choice of variance estimator for survey one, where
    "Local" = local mean estimator and "SRS" = SRS estimator.  The default is
    "Local".}
  \item{vartype_2}{the choice of variance estimator for survey two.  The default
    is "Local".}
  \item{conf}{the confidence level.  The default is 95\%.}
  \item{check.ind}{a logical value that indicates whether compatability
    checking of the input values is conducted, where TRUE = conduct 
    compatibility checking and FALSE = do not conduct compatibility 
    checking.  The default is TRUE.}
  \item{warn.ind}{a logical value that indicates whether warning messages were
    generated, where TRUE = warning messages were generated and FALSE = warning
    messages were not generated.  The default is NULL.}
  \item{warn.df}{a data frame for storing warning messages.  The default is
    NULL.}
  \item{warn.vec}{a vector that contains names of the population type, the
    subpopulation, and an indicator.  The default is NULL.}
}
\details{
  Change estimates are calculated using the Horvitz-Thompson ratio estimator,
  i.e., the ratio of two Horvitz-Thompson estimators.  The numerator of the
  ratio estimates the size of the category (for categorical variables) or the
  variable total (for a continuous variable).  The denominator of the ratio
  estimates the size of the resource.   Variance estimates for the proportion
  estimates are calculated using either the local mean variance estimator or the
  simple random sampling (SRS) variance estimator.  The choice of variance
  estimator is subject to user control.  The local mean variance estimator
  requires the x-coordinate and the y-coordinate of each site.  The
  SRS variance estimator uses the independent  random sample approximation
  to calculate joint inclusion probabilities.   Confidence bounds are calculated
  using a Normal distribution multiplier.  For a finite resource size is
  the number of units in the resource.  For an extensive resource size is the 
  measure (extent) of the resource, i.e., length, area, or volume.  Size 
  estimates are calculated using the Horvitz- Thompson estimator.  Variance 
  estimates for the size estimates are calculated using either the local mean 
  variance estimator or the SRS variance estimator. The function can 
  accommodate a stratified sample.  For a stratified sample, separate estimates 
  and standard errors are calculated for each stratum, which are used to produce 
  estimates and standard errors for all strata combined.  Strata that contain a 
  single value are removed.  For a stratified sample, when either the size of the
  resource or the sum of the size-weights for the resource is provided for each 
  stratum, those values are used as  stratum weights for calculating the 
  estimates and standard errors for all strata combined.  In addition, when 
  either of those known values is provided for each stratum, size estimates are 
  obtained by multiplying the proportion estimate, i.e., the Horvitz-Thompson 
  ratio estimator, by the known value for the stratum.  For a stratified sample 
  when neither the size of the  resource nor the sum of the size-weights of the 
  resource is provided for  each stratum, estimated values are used as stratum 
  weights for calculating  the estimates and standard errors for all strata 
  combined.  The function can accommodate single-stage and two-stage samples for 
  both stratified and unstratified sampling designs.  Finite population and 
  continuous population correction factors can be utilized in variance 
  estimation.  The function checks for compatibility of input values and removes
  missing values.
}
\section{Value}{
  If the function was called by the change.analysis function, then value is a
  list containing the following components:
  \itemize{
    \item \code{Results} - a data frame containing estimates and confidence
      bounds
    \item \code{warn.ind} - a logical value indicating whether warning messages
      were generated
    \item \code{warn.df} - a data frame containing warning messages
  }
  If the function was called directly, then value is a data frame containing
  estimates and confidence bounds.
}
\references{
  Diaz-Ramos, S., D.L. Stevens, Jr., and A.R. Olsen. (1996).  \emph{EMAP
  Statistical Methods Manual.} EPA/620/R-96/XXX.  Corvallis, OR: U.S.
  Environmental Protection Agency, Office of Research and Development, National
  Health Effects and Environmental Research Laboratory, Western Ecology
  Division.
}
\author{Tom Kincaid \email{Kincaid.Tom@epa.gov}}
\examples{
# Categorical variable example:
z_1 <- sample(c("Good","Fair","Poor"), 100, replace=TRUE)
z_2 <- sample(c("Good","Fair","Poor"), 100, replace=TRUE)
wgt_1 <- runif(100, 10, 100)
wgt_2 <- runif(100, 10, 100)
repeat_1 <- rep(c(TRUE,FALSE), c(20,80))
repeat_2 <- rep(c(TRUE,FALSE), c(20,80))
stratum_1 <- rep(c("Stratum1", "Stratum2"), 50)
stratum_2 <- rep(c("Stratum1", "Stratum2"), 50)
change.est(resp.ind="cat", z_1=z_1, wgt_1=wgt_1, repeat_1=repeat_1,
   z_2=z_2, wgt_2=wgt_2, repeat_2=repeat_2, stratum_1=stratum_1,
   stratum_2=stratum_2, vartype_1="SRS", vartype_2="SRS")

# Continuous variable example:
z_1 <- rnorm(100, 10,10)
z_2 <- rnorm(100, 12, 10)
stratum_1 <- rep(c("Stratum1", "Stratum2"), 50)
stratum_2 <- rep(c("Stratum1", "Stratum2"), 50)
change.est(resp.ind="cont", z_1=z_1, wgt_1=wgt_1, repeat_1=repeat_1,
   z_2=z_2, wgt_2=wgt_2, repeat_2=repeat_2, stratum_1=stratum_1,
   stratum_2=stratum_2, vartype_1="SRS", vartype_2="SRS")
}
\keyword{survey}
\keyword{univar}
