% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_player_recent_.R
\name{get_player_recent_games}
\alias{get_player_recent_games}
\title{Get a player's recent games from SquashInfo}
\usage{
get_player_recent_games(player = NULL, rank = NULL, category = NULL)
}
\arguments{
\item{player}{character string of player name.}

\item{rank}{single integer or vector of integers indicating the rank of the PSA player(s) to return.}

\item{category}{character string indicating the competition category. Must be one of "both", "mens", or "womens".}
}
\value{
Tibble containing the player rank, name, opponent, points won, points lost, game result, tournament round, event, PSA designation, and event location.
}
\description{
Given the full name or rank of a player and the competition category, \code{get_player_recent_games()} returns recent game data for PSA ranked players.
}
\note{
This function only returns data from players ranked in the most recent PSA rankings table for Men's and Women's singles competitions.
}
\examples{

## Get Mohamed Elshorbagy's most recent game data
\donttest{get_player_recent_games(player = "Mohamed Elshorbagy", category = "mens")}

## Get Nour El Tayeb's recent game data
\donttest{get_player_recent_games("El Tayeb", category = "womens")}

## Get recent game data from the top two players in both Men's and Women's competitions
\donttest{get_player_recent_games(rank = 1:2, category = "both")}

}
\references{
\url{http://www.squashinfo.com/rankings/men} \cr
    \url{http://www.squashinfo.com/rankings/women}
}
