% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_matchup.R
\name{get_matchup}
\alias{get_matchup}
\title{Get a player matchup data from SquashInfo}
\usage{
get_matchup(
  player_1 = NULL,
  player_2 = NULL,
  ranks = NULL,
  category = NULL,
  tidy = FALSE,
  match_spread = FALSE
)
}
\arguments{
\item{player_1}{character string of the first player's name.}

\item{player_2}{character string of the second player's name.}

\item{ranks}{integers indicating the rank of the PSA players to return.}

\item{category}{character string indicating the competition category. Must be one of "mens" or "womens".}

\item{tidy}{logical indicating whether to organize results according to tidy principles.}

\item{match_spread}{logical indicating whether to only return match spread statistics.}
}
\value{
Tibble containing each player's rank, name, total matches played, number of matches won, the match results spread (relative to player 1), the average match time, the number of games played, the number of games won, average point advantage in a won game, the average point difference in final scores, the number of tie-break wins, and the percentage of games that go to a tie-breaker.
}
\description{
Given the full names or ranks of players, and the competition category, \code{get_matchup()} returns recent matchup data for PSA ranked players.
}
\note{
This function only returns data from players ranked in the most recent PSA rankings table for Men's and Women's singles competitions.
}
\examples{

## Get tidy matchup data for Mohamed Elshorbagy vs Karim Abdel Gawad
\donttest{get_matchup(player_1 = "Mohamed Elshorbagy",
                      player_2 = "Karim Abdel Gawad",
                      category = "mens",
                      tidy = TRUE)}

## Get non-tidy matchup data for Nouran Gohar vs Nour El Sherbini
\donttest{get_matchup("Nouran Gohar", "Nour El Sherbini", category = "womens", tidy = FALSE)}

## Get tidy match spread data for Paul Coll and Ali Farag
\donttest{get_matchup("Paul Coll", "Ali Farag", category = "mens", tidy = TRUE, match_spread = TRUE)}


}
\references{
\url{http://www.squashinfo.com/rankings/men} \cr
    \url{http://www.squashinfo.com/rankings/women}
}
