% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sreg_stsi.R
\name{sreg_stsi}
\alias{sreg_stsi}
\title{Semiparametric Model-Assisted Estimation under a Stratified Sampling
with Simple Random Sampling Without Replace in each stratum.}
\usage{
sreg_stsi(
  location_formula,
  scale_formula,
  stratum,
  data,
  n,
  ss_sizes,
  allocation_type = "PA",
  aux_x,
  ...
)
}
\arguments{
\item{location_formula}{a symbolic description of the systematic component of the location model to be fitted.}

\item{scale_formula}{a symbolic description of the systematic component of the scale model to be fitted.}

\item{stratum}{vector, represents the strata of each unit in the population}

\item{data}{a data frame, list containing the variables in the model.}

\item{n}{integer, represents a fixed sample size.}

\item{ss_sizes}{vector, represents a vector with the sample size in each stratum.}

\item{allocation_type}{character, there is two choices, proportional allocation, 'PA', and x-optimal allocation,'XOA'. By default is a 'PA', Sarndal et. al. (2003).}

\item{aux_x}{vector, represents an auxiliary variable to help to calculate the sample sizes by the x-optimum allocation method, Sarndal et. al. (2003).
This option is validated only when the argument allocation_type is equal to 'XOA'.}

\item{...}{further parameters accepted by caret and survey functions.}
}
\value{
\code{sampling_design} is the name of the sampling design used in the estimation process.

\code{N} is the population size.

\code{H} is the number of strata.

\code{Ns} is the population strata sizes.

\code{allocation_type} is the method used to calculate sample strata sizes.

\code{global_n} is the global sample size used in the estimation process.

\code{first_order_probabilities} vector of the first order probabilities used in the estimation process.

\code{sample} is the random sample used in the estimation process.

\code{estimated_total_y_sreg} is the SREG estimate of the total parameter of the finite population.
}
\description{
\code{sreg_stsi} is used to estimate the total parameter of a finite population generated from a semi-parametric generalized gamma population
under a stratified sampling with simple random sampling without-replacement in each stratum.
}
\examples{
library(sregsurvey)
library(survey)
library(dplyr)
library(magrittr)
library(gamlss)
data(api)
attach(apipop)
Apipop <- filter(apipop,full!= 'NA')
Apipop <- Apipop \%>\% dplyr::select(api00,grad.sch,full,stype)
dim(Apipop)
sreg_stsi(api00 ~  pb(grad.sch),scale_formula = ~ full - 1, n=400, stratum = 'stype', data = Apipop)
# The total population value is
sum(Apipop$api00)

}
\references{
Cardozo C.A, Alonso C. (2021) Semi-parametric model assisted estimation in finite populations. In preparation.

Cardozo C.A.,  Paula G., and Vanegas L. (2021). Generalized log-gamma semiparametric models with P-spline smoothing. Submitted.

Sarndal C.E.,  Swensson B., and Wretman J. (2003). Model Assisted Survey Sampling. Springer-Verlag.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
