% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case-write.R
\name{case_index}
\alias{case_index}
\title{Write a case file for index data to the disk.}
\usage{
case_index(fleets = 1, years = NULL, sd = 2, case, spp)
}
\arguments{
\item{fleets}{Vector of fleet numbers, where the order of
\code{fleets} will dictate the order of all remaining arguments.}

\item{years}{A list of length \code{length(fleets)},
where each element of the list contains a vector of
years for the given fleet.}

\item{sd}{A list of standard deviations for each fleet.}

\item{case}{The case number you want to write to.
If \code{case = 1}, then the result will be \code{'index1'}.}

\item{spp}{A vector of character values argument specifying the species.}
}
\description{
Use \R code to write arguments to the disk, which
will later be used in a \pkg{ss3sim} simulation.
}
\examples{
case_index(fleets = 2, case = 1, spp = "cod", years = list(7:10), sd = 0.1)
done <- file.remove("index1-cod.txt")
}
