% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCA_helpers.R
\name{sparsity_group}
\alias{sparsity_group}
\title{Group-wise Sparsity in the Loadings}
\usage{
sparsity_group(PC, N, p, tolerance = 0, k = 1, scaled = TRUE)
}
\arguments{
\item{PC}{matrix-like object of PCs.}

\item{N}{integer, number of groups.}

\item{p}{integer, number of variables.}

\item{tolerance}{tolerance for sparsity.}

\item{k}{integer, which components should be used. Does not work for multiple PCs simultaneously.}

\item{scaled}{logical, if total number or percentage of possible sparse entries should be returned.}
}
\value{
Returns either a matrix of percentages (\code{scaled = TRUE}) or the amounts
 of zero-values entries (\code{scaled = FALSE}) for each group/neighborhood.
}
\description{
Group-wise Sparsity in the Loadings
}
\examples{
PC = matrix(c(1,0,2,3,0,7,0,1,0,1,0.001,0), ncol = 2)
sparsity_group(PC, N = 2, p = 3, tolerance = 0, k = 1, scaled = FALSE)
sparsity_group(PC, N = 2, p = 3, tolerance = 0.001, k = 2, scaled = TRUE)
}
