% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRPCAMS_methods.R
\name{screeplot.msPCA}
\alias{screeplot.msPCA}
\title{Scree Plot and Cumulative Explained Variance for msPCA Objects}
\usage{
\method{screeplot}{msPCA}(x, ...)
}
\arguments{
\item{x}{An object of class \code{msPCA}.}

\item{...}{Additional arguments to customize the plot:
\describe{
  \item{\code{text}}{Logical; whether to display numeric values on the heatmap (default: \code{TRUE}).}
  \item{\code{size}}{Numeric; text size for labels in the heatmap (default: 5).}
  \item{\code{cutoff}}{Numeric; cutoff threshold for explained variance lines and color midpoint, as a proportion (default: 0.8).}
  \item{\code{gnames}}{Character vector; optional custom group names (default: \code{N1}, \code{N2}, ..., \code{Nn}).}
  \item{\code{textrotate}}{Numeric; rotation angle of text labels on the heatmap (default: 90 degrees).}
}}
}
\value{
A list containing two \code{ggplot2} plot objects:
\itemize{
  \item A boxplot-based scree plot showing explained variance per principal component across groups.
  \item A tile plot showing cumulative explained variance per group and principal component.
}
}
\description{
Generates a scree plot displaying the explained variance of principal components
and a heatmap of cumulative explained variance per group for an object of class \code{msPCA}.
}
\examples{
set.seed(236)
data <- matrix(rnorm(1500), ncol = 5)
groups <- sample(1:5, 300, replace = TRUE)
W <- time_weights(N = 5, c(3,2,1))
covs <- ssMRCD(data, groups = groups, weights = W, lambda = 0.3)
pca <- msPCA(eta = 0.3, gamma = 0.7, COVS = covs$MRCDcov)
screeplot(pca, text = TRUE, cutoff = 0.8, size = 4, textrotate = 0)
screeplot(pca, text = FALSE, cutoff = 0.6)

}
