% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_shiny_outputs.R
\name{get_HCx_table}
\alias{get_HCx_table}
\title{Get HCx values from fit or bootstrap}
\usage{
get_HCx_table(fits, distributions, bootstrap = NULL, CI.level = 0.95)
}
\arguments{
\item{fits}{A list of fits of class \code{fitdist} or \code{fitdistcens}
computed from the same toxicity data.}

\item{distributions}{A list of the names of the distributions to apply (e.g.,
\code{'lnorm'}, \code{'llogis'})}

\item{bootstrap}{A list of \code{bootdist} or \code{bootdistcens} objects
corresponding to the fits provided.}

\item{CI.level}{A numeric, either 0.95 or 0.9. The level of the
confidence interval(s).}
}
\value{
A data.frame with different HCx as rows and different fits as
columns.
}
\description{
Get HC5, HC10, HC20 and HC50 for each fit provided, with confidence intervals
if the corresponding bootstraps were provided.
}
